"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getExtra = void 0;
function getExtra(extraValues, item, totalItems) {
    var _a, _b;
    const { seriesIdentifiers, defaultExtra, childId, path } = item;
    if (extraValues.size === 0 || seriesIdentifiers.length > 1 || !seriesIdentifiers[0]) {
        return defaultExtra ? { formatted: `${(_a = defaultExtra.formatted) !== null && _a !== void 0 ? _a : ''}`, raw: defaultExtra.raw } : null;
    }
    const [{ key }] = seriesIdentifiers;
    const extraValueKey = path.map(({ index }) => index).join('__');
    const itemExtraValues = extraValues.has(extraValueKey) ? extraValues.get(extraValueKey) : extraValues.get(key);
    const actionExtra = childId !== undefined ? itemExtraValues === null || itemExtraValues === void 0 ? void 0 : itemExtraValues.get(childId) : undefined;
    return actionExtra
        ? actionExtra
        : extraValues.size === totalItems && defaultExtra
            ? { formatted: `${(_b = defaultExtra.formatted) !== null && _b !== void 0 ? _b : ''}`, raw: defaultExtra.raw }
            : null;
}
exports.getExtra = getExtra;
//# sourceMappingURL=utils.js.map