"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDebugStateSelector = void 0;
const get_active_value_1 = require("./get_active_value");
const get_bullet_spec_1 = require("./get_bullet_spec");
const get_panel_dimensions_1 = require("./get_panel_dimensions");
const create_selector_1 = require("../../../state/create_selector");
exports.getDebugStateSelector = (0, create_selector_1.createCustomCachedSelector)([get_panel_dimensions_1.getPanelDimensions, get_active_value_1.getActiveValue, get_bullet_spec_1.getBulletSpec], (dimensions, activeValue, spec) => {
    return {
        bullet: {
            rows: dimensions.rows.map((row) => {
                return row.map((d) => {
                    if (!d)
                        return d;
                    const { datum, colorBands, ticks, domain } = d;
                    const { title, subtitle, target, value } = datum;
                    return {
                        title,
                        subtitle,
                        target,
                        value,
                        subtype: spec.subtype,
                        colorBands: colorBands.map((b) => b.color),
                        ticks,
                        domain,
                    };
                });
            }),
            activeValue: activeValue === null || activeValue === void 0 ? void 0 : activeValue.value,
        },
    };
});
//# sourceMappingURL=get_debug_state.js.map