"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonWatch = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _uuid = require("uuid");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _base_watch = require("./base_watch");
var _default_watch = require("./default_watch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * {@code JsonWatch} allows a user to create a Watch by writing the raw JSON.
 */
class JsonWatch extends _base_watch.BaseWatch {
  constructor(props = {}) {
    props.type = _constants.WATCH_TYPES.JSON;
    props.id = typeof props.id === 'undefined' ? (0, _uuid.v4)() : props.id;
    super(props);
    const existingWatch = (0, _lodash.get)(props, 'watch');
    this.watch = existingWatch ? existingWatch : _default_watch.defaultWatch;
    this.watchString = (0, _lodash.get)(props, 'watchString', JSON.stringify(existingWatch ? existingWatch : _default_watch.defaultWatch, null, 2));
    this.id = props.id;
  }
  validate() {
    const validationResult = {};
    const idRegex = /^[A-Za-z0-9\-\_.]+$/;
    const errors = {
      id: [],
      json: []
    };
    validationResult.errors = errors;
    // Watch id validation
    if (!this.id) {
      errors.id.push(_i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.error.requiredIdText', {
        defaultMessage: 'ID is required'
      }));
    } else if (!idRegex.test(this.id)) {
      errors.id.push(_i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.error.invalidIdText', {
        defaultMessage: 'ID can only contain letters, underscores, dashes, periods and numbers.'
      }));
    }
    // JSON validation
    if (!this.watchString || this.watchString === '') {
      errors.json.push(_i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.error.requiredJsonText', {
        defaultMessage: 'JSON is required'
      }));
    } else {
      try {
        const parsedJson = JSON.parse(this.watchString);
        if (parsedJson && typeof parsedJson === 'object') {
          const {
            actions
          } = parsedJson;
          if (actions) {
            // Validate if the action(s) provided is one of the supported actions
            const invalidActions = Object.keys(actions).find(actionKey => {
              const actionKeys = Object.keys(actions[actionKey]);
              let type;
              Object.keys(_constants.ACTION_TYPES).forEach(actionTypeKey => {
                if (actionKeys.includes(_constants.ACTION_TYPES[actionTypeKey]) && !actionKeys.includes(_constants.ACTION_TYPES.UNKNOWN)) {
                  type = _constants.ACTION_TYPES[actionTypeKey];
                }
              });
              return !type;
            });
            if (invalidActions) {
              errors.json.push(_i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.error.invalidActionType', {
                defaultMessage: 'Unknown action type provided for action "{action}".',
                values: {
                  action: invalidActions
                }
              }));
            }
          }
        }
      } catch (e) {
        errors.json.push(_i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.error.invalidJsonText', {
          defaultMessage: 'Invalid JSON'
        }));
      }
    }
    return validationResult;
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    Object.assign(result, {
      watch: this.watch
    });
    return result;
  }
  static fromUpstreamJson(upstreamWatch) {
    return new JsonWatch(upstreamWatch);
  }
}
exports.JsonWatch = JsonWatch;
(0, _defineProperty2.default)(JsonWatch, "typeName", _i18n.i18n.translate('xpack.watcher.models.jsonWatch.typeName', {
  defaultMessage: 'Advanced Watch'
}));
(0, _defineProperty2.default)(JsonWatch, "iconClass", '');
(0, _defineProperty2.default)(JsonWatch, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.jsonWatch.selectMessageText', {
  defaultMessage: 'Set up a custom watch in raw JSON.'
}));
(0, _defineProperty2.default)(JsonWatch, "isCreatable", true);
(0, _defineProperty2.default)(JsonWatch, "selectSortOrder", 100);