"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVisualizationSavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _configSchema = require("@kbn/config-schema");
var _content_management = require("../../common/content_management");
var _visualization_saved_object_migrations = require("../migrations/visualization_saved_object_migrations");
var _get_in_app_url = require("./get_in_app_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getVisualizationSavedObjectType = getSearchSourceMigrations => ({
  name: _content_management.CONTENT_ID,
  indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  convertToMultiNamespaceTypeVersion: '8.0.0',
  management: {
    icon: 'visualizeApp',
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl: _get_in_app_url.getInAppUrl
  },
  mappings: {
    dynamic: false,
    // declared here to prevent indexing root level attribute fields
    properties: {
      description: {
        type: 'text'
      },
      title: {
        type: 'text'
      },
      version: {
        type: 'integer'
      },
      kibanaSavedObjectMeta: {
        properties: {}
      }
    }
  },
  schemas: {
    '8.8.0': _configSchema.schema.object({
      title: _configSchema.schema.string(),
      description: _configSchema.schema.maybe(_configSchema.schema.string()),
      version: _configSchema.schema.maybe(_configSchema.schema.number()),
      kibanaSavedObjectMeta: _configSchema.schema.maybe(_configSchema.schema.object({
        searchSourceJSON: _configSchema.schema.string()
      })),
      uiStateJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
      visState: _configSchema.schema.maybe(_configSchema.schema.string()),
      savedSearchRefName: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  },
  migrations: () => (0, _visualization_saved_object_migrations.getAllMigrations)(getSearchSourceMigrations())
});
exports.getVisualizationSavedObjectType = getVisualizationSavedObjectType;