"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VegaPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _services = require("./services");
var _vega_fn = require("./vega_fn");
var _vega_type = require("./vega_type");
var _vega_inspector = require("./vega_inspector");
var _vega_vis_renderer = require("./vega_vis_renderer");
var _get_service_settings_lazy = require("./vega_view/vega_map_view/service_settings/get_service_settings_lazy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/** @internal */

/** @internal */

/** @internal */
class VegaPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    inspector,
    data,
    expressions,
    visualizations
  }) {
    (0, _services.setInjectedVars)({
      enableExternalUrls: this.initializerContext.config.get().enableExternalUrls
    });
    (0, _services.setUISettings)(core.uiSettings);
    const visualizationDependencies = {
      core,
      plugins: {
        data
      },
      getServiceSettings: _get_service_settings_lazy.getServiceSettingsLazy
    };
    inspector.registerView((0, _vega_inspector.getVegaInspectorView)({
      uiSettings: core.uiSettings
    }));
    expressions.registerFunction(() => (0, _vega_fn.createVegaFn)(visualizationDependencies));
    expressions.registerRenderer((0, _vega_vis_renderer.getVegaVisRenderer)(visualizationDependencies));
    visualizations.createBaseVisualization((0, _vega_type.createVegaTypeDefinition)());
  }
  start(core, {
    data,
    mapsEms,
    dataViews,
    usageCollection
  }) {
    (0, _services.setNotifications)(core.notifications);
    (0, _services.setData)(data);
    (0, _services.setDataViews)(dataViews);
    (0, _services.setDocLinks)(core.docLinks);
    (0, _services.setMapsEms)(mapsEms);
    (0, _services.setUsageCollectionStart)(usageCollection);
  }
}
exports.VegaPlugin = VegaPlugin;