"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildCounterRateFormula = void 0;
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildMaxFormula = (selector, additionalArgs) => {
  return `max(${selector}${(0, _.addAdditionalArgs)(additionalArgs)})`;
};
const buildСounterRateFormula = (aggFormula, selector) => {
  return `${aggFormula}(${selector})`;
};
const buildCounterRateFormula = (aggFormula, fieldName, additionalArgs) => {
  const maxFormula = buildMaxFormula(fieldName, additionalArgs);
  const counterRateFormula = buildСounterRateFormula(aggFormula, maxFormula);
  return counterRateFormula;
};
exports.buildCounterRateFormula = buildCounterRateFormula;