"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Annotation = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
require("./_annotation.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Annotation extends _react.Component {
  constructor(props) {
    super(props);
  }
  renderTooltip() {
    const [timestamp, messageSource] = this.props.series;
    const messages = messageSource.map((message, i) => {
      return /*#__PURE__*/_react.default.createElement("div", {
        key: `${message}-${i}`,
        className: "tvbVisAnnotation__message"
      }, message);
    });
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbTooltip__timestamp"
    }, (0, _moment.default)(timestamp).format('lll')), messages);
  }
  render() {
    const {
      color,
      plot,
      icon,
      series
    } = this.props;
    const offset = plot.pointOffset({
      x: series[0],
      y: 0
    });
    const tooltip = this.renderTooltip();
    const containerCSS = (0, _react2.css)`
      left: ${offset.left - 6}px;
      bottom: 0;
      top: 5px;
    `;
    const lineCSS = (0, _react2.css)`
      backgroundcolor: ${color};
    `;
    const iconCSS = (0, _react2.css)`
      color: ${color};
    `;
    return /*#__PURE__*/_react.default.createElement("div", {
      css: containerCSS,
      className: "tvbVisAnnotation"
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: lineCSS,
      className: "tvbVisAnnotation__line"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      className: "tvbVisAnnotation__tooltip",
      content: tooltip,
      position: "top"
    }, /*#__PURE__*/_react.default.createElement("i", {
      css: iconCSS,
      className: `tvbVisAnnotation__icon fa ${icon}`
    })));
  }
}
exports.Annotation = Annotation;
Annotation.propTypes = {
  series: _propTypes.default.array,
  icon: _propTypes.default.string,
  color: _propTypes.default.string,
  plot: _propTypes.default.object
};