"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAxisLabelString = getAxisLabelString;
var _get_interval = require("./get_interval");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getAxisLabelString(interval) {
  if (!interval) {
    return '';
  }
  const convertedValue = (0, _get_interval.convertIntervalIntoUnit)(interval);
  if (convertedValue) {
    return _i18n.i18n.translate('visTypeTimeseries.axisLabelOptions.axisLabel', {
      defaultMessage: 'per {unitValue} {unitString}',
      values: {
        unitValue: convertedValue.unitValue,
        unitString: convertedValue.unitString
      }
    });
  }
}