"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newAnnotation = exports.AnnotationsEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _annotation_row = require("./annotation_row");
var _collection_actions = require("./lib/collection_actions");
require("./_annotations_editor.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const newAnnotation = defaultIndexPattern => () => ({
  id: (0, _uuid.v4)(),
  color: '#F00',
  index_pattern: defaultIndexPattern && defaultIndexPattern.id ? {
    id: defaultIndexPattern.id
  } : '',
  time_field: '',
  icon: 'fa-tag',
  ignore_global_filters: 1,
  ignore_panel_filters: 1
});
exports.newAnnotation = newAnnotation;
const NoContent = ({
  handleAdd
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  textAlign: "center"
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visTypeTimeseries.annotationsEditor.howToCreateAnnotationDataSourceDescription",
  defaultMessage: "Click the button below to create an annotation data source."
})), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  fill: true,
  onClick: handleAdd,
  "data-test-subj": "addDataSourceButton"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visTypeTimeseries.annotationsEditor.addDataSourceButtonLabel",
  defaultMessage: "Add data source"
})));
const getCollectionActionsProps = props => ({
  name: 'annotations',
  ...props
});
const AnnotationsEditor = props => {
  const {
    annotations
  } = props.model;
  const handleAdd = (0, _react.useCallback)(() => _collection_actions.collectionActions.handleAdd(getCollectionActionsProps(props), newAnnotation(props.defaultIndexPattern)), [props]);
  const handleDelete = (0, _react.useCallback)(annotation => () => _collection_actions.collectionActions.handleDelete(getCollectionActionsProps(props), annotation), [props]);
  const onChange = (0, _react.useCallback)(annotation => {
    return part => _collection_actions.collectionActions.handleChange(getCollectionActionsProps(props), {
      ...annotation,
      ...part
    });
  }, [props]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbAnnotationsEditor__container"
  }, annotations !== null && annotations !== void 0 && annotations.length ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.annotationsEditor.dataSourcesLabel",
    defaultMessage: "Data sources"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), annotations.map(annotation => /*#__PURE__*/_react.default.createElement(_annotation_row.AnnotationRow, {
    key: annotation.id,
    annotation: annotation,
    fields: props.fields,
    onChange: onChange(annotation),
    handleAdd: handleAdd,
    handleDelete: handleDelete(annotation)
  }))) : /*#__PURE__*/_react.default.createElement(NoContent, {
    handleAdd: handleAdd
  }));
};
exports.AnnotationsEditor = AnnotationsEditor;