"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelect = FieldSelect;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _field_select_item = require("./field_select_item");
var _index_patterns_utils = require("../../../../../common/index_patterns_utils");
var _multi_field_select = require("./multi_field_select");
var _field_select_utils = require("./field_select_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getPlaceholderValue = (placeholder, options) => {
  var _findInGroupedOptions;
  if (!placeholder) {
    return;
  }
  return ((_findInGroupedOptions = (0, _field_select_utils.findInGroupedOptions)(options, placeholder)) === null || _findInGroupedOptions === void 0 ? void 0 : _findInGroupedOptions.label) || placeholder;
};
function FieldSelect({
  label,
  fullWidth,
  type,
  value,
  fields,
  indexPattern,
  uiRestrictions,
  restrict,
  onChange,
  disabled,
  placeholder,
  allowMultiSelect = false,
  'data-test-subj': dataTestSubj
}) {
  const htmlId = (0, _eui.htmlIdGenerator)();
  const fieldsSelector = (0, _index_patterns_utils.getIndexPatternKey)(indexPattern);
  const selectedIds = (0, _react.useMemo)(() => [value !== null && value !== void 0 ? value : null].flat(), [value]);
  const groupedOptions = (0, _react.useMemo)(() => (0, _field_select_utils.getGroupedOptions)(type, selectedIds, fields[fieldsSelector], uiRestrictions, restrict), [fields, fieldsSelector, restrict, selectedIds, type, uiRestrictions]);
  const selectedOptionsMap = (0, _react.useMemo)(() => {
    const map = new Map();
    if (selectedIds) {
      const addIntoSet = item => {
        const option = (0, _field_select_utils.findInGroupedOptions)(groupedOptions, item);
        if (option) {
          map.set(item, [option]);
        } else {
          map.set(item, [{
            label: item,
            id: _field_select_utils.INVALID_FIELD_ID
          }]);
        }
      };
      selectedIds.forEach(v => v && addIntoSet(v));
    }
    return map;
  }, [groupedOptions, selectedIds]);
  const invalidSelectedOptions = (0, _react.useMemo)(() => [...selectedOptionsMap.values()].flat().filter(item => (item === null || item === void 0 ? void 0 : item.label) && (item === null || item === void 0 ? void 0 : item.id) === _field_select_utils.INVALID_FIELD_ID).map(item => item.label), [selectedOptionsMap]);
  const onFieldSelectItemChange = (0, _react.useCallback)((index = 0, [selectedItem]) => {
    onChange((0, _field_select_utils.updateItem)(selectedIds, selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.value, index));
  }, [selectedIds, onChange]);
  const onNewItemAdd = (0, _react.useCallback)(index => onChange((0, _field_select_utils.addNewItem)(selectedIds, index)), [selectedIds, onChange]);
  const onDeleteItem = (0, _react.useCallback)(index => onChange((0, _field_select_utils.deleteItem)(selectedIds, index)), [onChange, selectedIds]);
  const onDragEnd = (0, _react.useCallback)(({
    source,
    destination
  }) => {
    if (destination && source.index !== (destination === null || destination === void 0 ? void 0 : destination.index)) {
      onChange((0, _field_select_utils.swapItems)(selectedIds, source.index, destination.index));
    }
  }, [onChange, selectedIds]);
  const FieldSelectItemFactory = (0, _react.useMemo)(() => props => {
    var _ref;
    return /*#__PURE__*/_react.default.createElement(_field_select_item.FieldSelectItem, {
      options: groupedOptions,
      selectedOptions: (_ref = props.value ? selectedOptionsMap.get(props.value) : undefined) !== null && _ref !== void 0 ? _ref : [],
      disabled: disabled,
      onNewItemAdd: onNewItemAdd.bind(undefined, props.index),
      onDeleteItem: onDeleteItem.bind(undefined, props.index),
      onChange: onFieldSelectItemChange.bind(undefined, props.index),
      placeholder: getPlaceholderValue(placeholder, groupedOptions),
      disableAdd: !allowMultiSelect || (selectedIds === null || selectedIds === void 0 ? void 0 : selectedIds.length) >= _field_select_utils.MAX_MULTI_FIELDS_ITEMS,
      disableDelete: !allowMultiSelect || (selectedIds === null || selectedIds === void 0 ? void 0 : selectedIds.length) <= 1
    });
  }, [groupedOptions, selectedOptionsMap, disabled, onNewItemAdd, onDeleteItem, onFieldSelectItemChange, placeholder, allowMultiSelect, selectedIds === null || selectedIds === void 0 ? void 0 : selectedIds.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('fieldSelect'),
    label: label,
    error: _i18n.i18n.translate('visTypeTimeseries.fieldSelect.fieldIsNotValid', {
      defaultMessage: 'The "{fieldParameter}" selection is not valid for use with the current index.',
      values: {
        fieldParameter: invalidSelectedOptions.join(', ')
      }
    }),
    fullWidth: fullWidth,
    isInvalid: Boolean(invalidSelectedOptions.length),
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'metricsIndexPatternFieldsSelect'
  }, (selectedIds === null || selectedIds === void 0 ? void 0 : selectedIds.length) > 1 ? /*#__PURE__*/_react.default.createElement(_multi_field_select.MultiFieldSelect, {
    values: selectedIds,
    onDragEnd: onDragEnd,
    WrappedComponent: FieldSelectItemFactory
  }) : /*#__PURE__*/_react.default.createElement(FieldSelectItemFactory, {
    value: selectedIds === null || selectedIds === void 0 ? void 0 : selectedIds[0]
  }));
}