"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TableOptions;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/vis-default-editor-plugin/public");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  tabifyGetColumns
} = _public.search;
function TableOptions({
  aggs,
  stateParams,
  setValidity,
  setValue
}) {
  const percentageColumns = (0, _react.useMemo)(() => [{
    value: '',
    text: _i18n.i18n.translate('visTypeTable.params.defaultPercentageCol', {
      defaultMessage: 'Don’t show'
    })
  }, ...tabifyGetColumns(aggs.getResponseAggs(), true).filter(col => (0, _lodash.get)(col.aggConfig.toSerializedFieldFormat(), 'id') === 'number').map(({
    name
  }) => ({
    value: name,
    text: name
  }))], [aggs]);
  const isPerPageValid = stateParams.perPage === '' || stateParams.perPage > 0;
  (0, _react.useEffect)(() => {
    setValidity(isPerPageValid);
  }, [isPerPageValid, setValidity]);
  (0, _react.useEffect)(() => {
    if (!percentageColumns.find(({
      value
    }) => value === stateParams.percentageCol) && percentageColumns[0] && percentageColumns[0].value !== stateParams.percentageCol) {
      setValue('percentageCol', percentageColumns[0].value);
    }
  }, [percentageColumns, stateParams.percentageCol, setValidity, setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_public2.NumberInputOption, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTable.params.perPageLabel",
      defaultMessage: "Max rows per page"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: "Leaving this field empty means it will use number of buckets from the response.",
      position: "right"
    })),
    isInvalid: !isPerPageValid,
    min: 1,
    paramName: "perPage",
    value: stateParams.perPage,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_public2.SwitchOption, {
    label: _i18n.i18n.translate('visTypeTable.params.showMetricsLabel', {
      defaultMessage: 'Show metrics for every bucket/level'
    }),
    paramName: "showMetricsAtAllLevels",
    value: stateParams.showMetricsAtAllLevels,
    setValue: setValue,
    "data-test-subj": "showMetricsAtAllLevels"
  }), /*#__PURE__*/_react.default.createElement(_public2.SwitchOption, {
    label: _i18n.i18n.translate('visTypeTable.params.autoFitRow', {
      defaultMessage: 'Auto fit rows to content'
    }),
    paramName: "autoFitRowToContent",
    value: stateParams.autoFitRowToContent,
    setValue: setValue,
    "data-test-subj": "autoFitRowToContent"
  }), /*#__PURE__*/_react.default.createElement(_public2.SwitchOption, {
    label: _i18n.i18n.translate('visTypeTable.params.showPartialRowsLabel', {
      defaultMessage: 'Show partial rows'
    }),
    tooltip: _i18n.i18n.translate('visTypeTable.params.showPartialRowsTip', {
      defaultMessage: 'Show rows that have partial data. This will still calculate metrics for every bucket/level, even if they are not displayed.'
    }),
    paramName: "showPartialRows",
    value: stateParams.showPartialRows,
    setValue: setValue,
    "data-test-subj": "showPartialRows"
  }), /*#__PURE__*/_react.default.createElement(_public2.SwitchOption, {
    label: _i18n.i18n.translate('visTypeTable.params.showToolbarLabel', {
      defaultMessage: 'Show toolbar'
    }),
    paramName: "showToolbar",
    value: stateParams.showToolbar,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_public2.SwitchOption, {
    label: _i18n.i18n.translate('visTypeTable.params.showTotalLabel', {
      defaultMessage: 'Show total'
    }),
    paramName: "showTotal",
    value: stateParams.showTotal,
    setValue: setValue,
    "data-test-subj": "showTotal"
  }), /*#__PURE__*/_react.default.createElement(_public2.SelectOption, {
    label: _i18n.i18n.translate('visTypeTable.params.totalFunctionLabel', {
      defaultMessage: 'Total function'
    }),
    disabled: !stateParams.showTotal,
    options: _utils.totalAggregations,
    paramName: "totalFunc",
    value: stateParams.totalFunc,
    setValue: setValue,
    "data-test-subj": "totalFunction"
  }), /*#__PURE__*/_react.default.createElement(_public2.SelectOption, {
    label: _i18n.i18n.translate('visTypeTable.params.PercentageColLabel', {
      defaultMessage: 'Percentage column'
    }),
    options: percentageColumns,
    paramName: "percentageCol",
    value: stateParams.percentageCol,
    setValue: setValue,
    id: "datatableVisualizationPercentageCol"
  }));
}
// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;