"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncateLabelsOption = TruncateLabelsOption;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function TruncateLabelsOption({
  disabled,
  value = null,
  setValue
}) {
  const onChange = ev => setValue('truncate', ev.target.value === '' ? null : parseFloat(ev.target.value));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypePie.controls.truncateLabel', {
      defaultMessage: 'Truncate'
    }),
    fullWidth: true,
    display: "rowCompressed",
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('visTypePie.controls.truncateTooltip', {
        defaultMessage: 'Number of characters for labels positioned outside the chart.'
      }),
      position: "top",
      type: "iInCircle",
      color: "subdued"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "pieLabelTruncateInput",
    disabled: disabled,
    value: value || '',
    onChange: onChange,
    fullWidth: true,
    compressed: true
  }));
}