"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/expressions-plugin/public");
var _palette = require("./utils/palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_PERCENT_DECIMALS = 2;
const prepareLegend = params => {
  var _params$truncateLegen, _params$maxLegendLine;
  const legend = (0, _public2.buildExpressionFunction)('heatmap_legend', {
    isVisible: params.addLegend,
    position: params.legendPosition,
    shouldTruncate: (_params$truncateLegen = params.truncateLegend) !== null && _params$truncateLegen !== void 0 ? _params$truncateLegen : true,
    maxLines: (_params$maxLegendLine = params.maxLegendLines) !== null && _params$maxLegendLine !== void 0 ? _params$maxLegendLine : 1,
    legendSize: params.legendSize
  });
  return (0, _public2.buildExpression)([legend]);
};
const prepareDimension = params => {
  const visdimension = (0, _public2.buildExpressionFunction)('visdimension', {
    accessor: params.accessor
  });
  if (params.format) {
    visdimension.addArgument('format', params.format.id);
    visdimension.addArgument('formatParams', JSON.stringify(params.format.params));
  }
  return (0, _public2.buildExpression)([visdimension]);
};
const prepareGrid = params => {
  var _params$valueAxes$0$l, _params$valueAxes;
  const gridConfig = (0, _public2.buildExpressionFunction)('heatmap_grid', {
    isCellLabelVisible: (_params$valueAxes$0$l = (_params$valueAxes = params.valueAxes) === null || _params$valueAxes === void 0 ? void 0 : _params$valueAxes[0].labels.show) !== null && _params$valueAxes$0$l !== void 0 ? _params$valueAxes$0$l : false,
    isXAxisLabelVisible: true,
    isYAxisLabelVisible: true,
    isYAxisTitleVisible: true,
    isXAxisTitleVisible: true
  });
  return (0, _public2.buildExpression)([gridConfig]);
};
const toExpressionAst = async (vis, params) => {
  var _vis$params$lastRange;
  const schemas = (0, _public.getVisSchemas)(vis, params);

  // fix formatter for percentage mode
  if (vis.params.percentageMode === true) {
    schemas.metric.forEach(metric => {
      var _vis$params$percentag;
      metric.format = {
        id: 'percent',
        params: {
          pattern: (_vis$params$percentag = vis.params.percentageFormatPattern) !== null && _vis$params$percentag !== void 0 ? _vis$params$percentag : `0,0.[${'0'.repeat(DEFAULT_PERCENT_DECIMALS)}]%`
        }
      };
    });
  }
  const expressionArgs = {
    showTooltip: vis.params.addTooltip,
    highlightInHover: vis.params.enableHover,
    lastRangeIsRightOpen: (_vis$params$lastRange = vis.params.lastRangeIsRightOpen) !== null && _vis$params$lastRange !== void 0 ? _vis$params$lastRange : false,
    percentageMode: vis.params.percentageMode,
    legend: prepareLegend(vis.params),
    gridConfig: prepareGrid(vis.params)
  };
  const visTypeHeatmap = (0, _public2.buildExpressionFunction)('heatmap', expressionArgs);
  if (schemas.metric.length) {
    visTypeHeatmap.addArgument('valueAccessor', prepareDimension(schemas.metric[0]));
  }
  if (schemas.segment && schemas.segment.length) {
    visTypeHeatmap.addArgument('xAccessor', prepareDimension(schemas.segment[0]));
  }
  if (schemas.group && schemas.group.length) {
    visTypeHeatmap.addArgument('yAccessor', prepareDimension(schemas.group[0]));
  }
  if (schemas.split_row && schemas.split_row.length) {
    visTypeHeatmap.addArgument('splitRowAccessor', prepareDimension(schemas.split_row[0]));
  }
  if (schemas.split_column && schemas.split_column.length) {
    visTypeHeatmap.addArgument('splitColumnAccessor', prepareDimension(schemas.split_column[0]));
  }
  let palette;
  if (vis.params.setColorRange && vis.params.colorsRange && vis.params.colorsRange.length) {
    var _vis$params;
    const stopsWithColors = (0, _palette.getStopsWithColorsFromRanges)(vis.params.colorsRange, vis.params.colorSchema, vis.params.invertColors);
    // palette is type of number, if user gives specific ranges
    palette = (0, _public2.buildExpressionFunction)('palette', {
      ...stopsWithColors,
      range: 'number',
      continuity: 'none',
      rangeMin: vis.params.setColorRange && vis.params.colorsRange && vis.params.colorsRange.length ? vis.params.colorsRange[0].from : undefined,
      rangeMax: vis.params.setColorRange && vis.params.colorsRange && vis.params.colorsRange.length ? vis.params.colorsRange[((_vis$params = vis.params) === null || _vis$params === void 0 ? void 0 : _vis$params.colorsRange.length) - 1].to : undefined
    });
  } else {
    // palette is type of percent, if user wants dynamic calulated ranges
    const stopsWithColors = (0, _palette.getStopsWithColorsFromColorsNumber)(vis.params.colorsNumber, vis.params.colorSchema, vis.params.invertColors);
    palette = (0, _public2.buildExpressionFunction)('palette', {
      ...stopsWithColors,
      range: 'percent',
      continuity: 'none',
      rangeMin: 0,
      rangeMax: 100
    });
  }
  visTypeHeatmap.addArgument('palette', (0, _public2.buildExpression)([palette]));
  const ast = (0, _public2.buildExpression)([visTypeHeatmap]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;