"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPaletteForHeatmap = void 0;
var _public = require("@kbn/visualizations-plugin/public");
var _palette = require("../../utils/palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isHeatmapVisParamsWithRanges = params => {
  return Boolean(params.setColorRange && params.colorsRange && params.colorsRange.length);
};
const getPaletteForHeatmap = async params => {
  const {
    getPalette,
    getPaletteFromStopsWithColors,
    getPercentageModeConfig
  } = await _public.convertToLensModule;
  if (isHeatmapVisParamsWithRanges(params)) {
    const percentageModeConfig = getPercentageModeConfig(params, false);
    return getPalette(params, percentageModeConfig, params.percentageMode);
  }
  const {
    color,
    stop = []
  } = (0, _palette.getStopsWithColorsFromColorsNumber)(params.colorsNumber, params.colorSchema, params.invertColors, true);
  const colorsRange = [{
    from: stop[0],
    to: stop[stop.length - 1],
    type: 'range'
  }];
  const {
    colorSchema,
    invertColors
  } = params;
  // palette is type of percent, if user wants dynamic calulated ranges
  const percentageModeConfig = getPercentageModeConfig({
    colorsRange,
    colorSchema,
    invertColors,
    percentageMode: true
  }, false);
  return getPaletteFromStopsWithColors({
    color,
    stop: stop !== null && stop !== void 0 ? stop : []
  }, percentageModeConfig, true);
};
exports.getPaletteForHeatmap = getPaletteForHeatmap;