"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/expressions-plugin/public");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const prepareDimension = params => {
  const visdimension = (0, _public2.buildExpressionFunction)('visdimension', {
    accessor: params.accessor
  });
  if (params.format) {
    visdimension.addArgument('format', params.format.id);
    visdimension.addArgument('formatParams', JSON.stringify(params.format.params));
  }
  return (0, _public2.buildExpression)([visdimension]);
};
const gaugeTypeToShape = type => {
  const arc = 'arc';
  const circle = 'circle';
  return {
    [_types.GaugeType.Arc]: arc,
    [_types.GaugeType.Circle]: circle
  }[type];
};
const toExpressionAst = (vis, params) => {
  var _schemas$metric, _schemas$metric$;
  const schemas = (0, _public.getVisSchemas)(vis, params);
  const {
    gaugeType,
    percentageMode,
    percentageFormatPattern,
    colorSchema,
    colorsRange,
    invertColors,
    scale,
    style,
    labels
  } = vis.params.gauge;

  // fix formatter for percentage mode
  if (percentageMode === true) {
    schemas.metric.forEach(metric => {
      metric.format = {
        id: 'percent',
        params: {
          pattern: percentageFormatPattern
        }
      };
    });
  }
  const centralMajorMode = labels.show ? style.subText ? 'custom' : 'auto' : 'none';
  const gauge = (0, _public2.buildExpressionFunction)('gauge', {
    shape: gaugeTypeToShape(gaugeType),
    metric: schemas.metric.map(prepareDimension),
    ticksPosition: scale.show ? 'auto' : 'hidden',
    labelMajorMode: 'none',
    colorMode: 'palette',
    centralMajorMode,
    ...(centralMajorMode === 'custom' ? {
      labelMinor: style.subText
    } : {}),
    percentageMode,
    respectRanges: true,
    commonLabel: (_schemas$metric = schemas.metric) === null || _schemas$metric === void 0 ? void 0 : (_schemas$metric$ = _schemas$metric[0]) === null || _schemas$metric$ === void 0 ? void 0 : _schemas$metric$.label
  });
  if (colorsRange && colorsRange.length) {
    const stopsWithColors = (0, _utils.getStopsWithColorsFromRanges)(colorsRange, colorSchema, invertColors);
    const palette = (0, _public2.buildExpressionFunction)('palette', {
      ...stopsWithColors,
      range: percentageMode ? 'percent' : 'number',
      continuity: 'none',
      gradient: true,
      rangeMax: percentageMode ? 100 : stopsWithColors.stop[stopsWithColors.stop.length - 1],
      rangeMin: stopsWithColors.stop[0]
    });
    gauge.addArgument('palette', (0, _public2.buildExpression)([palette]));
  }
  const ast = (0, _public2.buildExpression)([gauge]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;