"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditorFormState = useEditorFormState;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const initialFormState = {
  validity: {},
  touched: false,
  invalid: false
};
function useEditorFormState() {
  const [formState, setFormState] = (0, _react.useState)(initialFormState);
  const setValidity = (0, _react.useCallback)((modelName, value) => {
    setFormState(model => {
      const validity = {
        ...model.validity,
        [modelName]: value
      };
      return {
        ...model,
        validity,
        invalid: Object.values(validity).some(valid => !valid)
      };
    });
  }, []);
  const resetValidity = (0, _react.useCallback)(() => {
    setFormState(initialFormState);
  }, []);
  const setTouched = (0, _react.useCallback)(touched => {
    setFormState(model => ({
      ...model,
      touched
    }));
  }, []);
  return {
    formState,
    setValidity,
    setTouched,
    resetValidity
  };
}