"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendSizeSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/visualizations-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const legendSizeOptions = [{
  value: _public.LegendSize.SMALL,
  inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.small', {
    defaultMessage: 'Small'
  })
}, {
  value: _public.LegendSize.MEDIUM,
  inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.medium', {
    defaultMessage: 'Medium'
  })
}, {
  value: _public.LegendSize.LARGE,
  inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.large', {
    defaultMessage: 'Large'
  })
}, {
  value: _public.LegendSize.EXTRA_LARGE,
  inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.extraLarge', {
    defaultMessage: 'Extra large'
  })
}];
const LegendSizeSettings = ({
  legendSize,
  onLegendSizeChange,
  isVerticalLegend,
  showAutoOption
}) => {
  (0, _react.useEffect)(() => {
    if (legendSize && !isVerticalLegend) {
      onLegendSizeChange(undefined);
    }
  }, [isVerticalLegend, legendSize, onLegendSizeChange]);
  const onLegendSizeOptionChange = (0, _react.useCallback)(option => onLegendSizeChange(option === _public.DEFAULT_LEGEND_SIZE ? undefined : option), [onLegendSizeChange]);
  const options = showAutoOption ? [{
    value: _public.LegendSize.AUTO,
    inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.auto', {
      defaultMessage: 'Auto'
    })
  }, ...legendSizeOptions] : legendSizeOptions;
  const legendSizeSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    compressed: true,
    valueOfSelected: legendSize !== null && legendSize !== void 0 ? legendSize : _public.DEFAULT_LEGEND_SIZE,
    options: options,
    onChange: onLegendSizeOptionChange,
    disabled: !isVerticalLegend
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visDefaultEditor.options.legendSizeSetting.label",
      defaultMessage: "Legend size"
    })
  }, isVerticalLegend ? legendSizeSelect : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendVertical', {
      defaultMessage: 'Requires legend to be right or left aligned'
    }),
    position: "top",
    delay: "regular",
    display: "block"
  }, legendSizeSelect));
};
exports.LegendSizeSettings = LegendSizeSettings;