"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RawJsonParamEditor = RawJsonParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/es-ui-shared-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function RawJsonParamEditor({
  showValidation,
  value = '',
  setValidity,
  setValue,
  setTouched
}) {
  const [isFieldValid, setFieldValidity] = (0, _react.useState)(true);
  const editorTooltipText = (0, _react.useMemo)(() => _i18n.i18n.translate('visDefaultEditor.controls.jsonInputTooltip', {
    defaultMessage: "Any JSON formatted properties you add here will be merged with the elasticsearch aggregation definition for this section. For example 'shard_size' on a terms aggregation."
  }), []);
  const jsonEditorLabelText = (0, _react.useMemo)(() => _i18n.i18n.translate('visDefaultEditor.controls.jsonInputLabel', {
    defaultMessage: 'JSON input'
  }), []);
  const label = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jsonEditorLabelText, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    content: editorTooltipText,
    type: "questionInCircle"
  })), [jsonEditorLabelText, editorTooltipText]);
  const onChange = (0, _react.useCallback)(newValue => {
    setValue(newValue);
    // validation for value
    let isJsonValid = true;
    try {
      if (newValue) {
        JSON.parse(_public2.XJson.collapseLiteralStrings(newValue));
      }
    } catch (e) {
      isJsonValid = false;
    }
    setFieldValidity(isJsonValid);
    setValidity(isJsonValid);
  }, [setValidity, setFieldValidity, setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    isInvalid: showValidation ? !isFieldValid : false,
    fullWidth: true,
    display: "rowCompressed",
    onBlur: setTouched
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    "aria-label": jsonEditorLabelText,
    "aria-describedby": "jsonEditorDescription",
    languageId: _monaco.XJsonLang.ID,
    languageConfiguration: {
      autoClosingPairs: [{
        open: '{',
        close: '}'
      }]
    },
    width: "100%",
    height: "250px",
    value: value,
    onChange: onChange,
    options: {
      renderValidationDecorations: value ? 'on' : 'off',
      lineNumbers: 'on',
      fontSize: 14,
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      folding: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    }
  })));
}