"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorAggParam = DefaultEditorAggParam;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _agg_params_state = require("./agg_params_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DefaultEditorAggParam(props) {
  const {
    agg,
    aggParam,
    paramEditor: ParamEditor,
    setAggParamValue,
    onChangeParamsState,
    ...rest
  } = props;
  const setValidity = (0, _react.useCallback)(valid => {
    onChangeParamsState({
      type: _agg_params_state.AGG_PARAMS_ACTION_KEYS.VALID,
      paramName: aggParam.name,
      payload: valid
    });
  }, [onChangeParamsState, aggParam.name]);

  // setTouched can be called from sub-agg which passes a parameter
  const setTouched = (0, _react.useCallback)((isTouched = true) => {
    onChangeParamsState({
      type: _agg_params_state.AGG_PARAMS_ACTION_KEYS.TOUCHED,
      paramName: aggParam.name,
      payload: isTouched
    });
  }, [onChangeParamsState, aggParam.name]);
  const setValue = (0, _react.useCallback)(value => {
    if (props.value !== value) {
      setAggParamValue(agg.id, aggParam.name, value);
    }
  }, [setAggParamValue, agg.id, aggParam.name, props.value]);
  (0, _react.useEffect)(() => {
    if (aggParam.shouldShow && !aggParam.shouldShow(agg)) {
      setValidity(true);
    }
  }, [agg, agg.params.field, aggParam, setValidity]);
  if (aggParam.shouldShow && !aggParam.shouldShow(agg)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ParamEditor, (0, _extends2.default)({
    agg: agg,
    aggParam: aggParam,
    setValidity: setValidity,
    setTouched: setTouched,
    setValue: setValue
  }, rest));
}