"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExploratoryViewFilter = getExploratoryViewFilter;
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _ux_ui_filter = require("../../../common/ux_ui_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getExploratoryViewFilter(uiFilters, urlParams) {
  const {
    searchTerm
  } = urlParams;
  const validFilters = _ux_ui_filter.uxLocalUIFilterNames.filter(name => name in uiFilters && name !== 'serviceName');
  const filters = {};
  validFilters.forEach(filterName => {
    var _filters$field$fieldN;
    const field = _ux_ui_filter.uxLocalUIFilters[filterName];
    const value = uiFilters[filterName];
    let curr = (_filters$field$fieldN = filters[field.fieldName]) !== null && _filters$field$fieldN !== void 0 ? _filters$field$fieldN : {
      field: field.fieldName
    };
    if (filterName.includes('Excluded')) {
      curr = {
        ...curr,
        notValues: value ? [...value] : value
      };
    } else {
      curr = {
        ...curr,
        values: value ? [...value] : value
      };
    }
    filters[field.fieldName] = curr;
  });
  if (searchTerm) {
    const urlFilter = {
      field: _elasticsearch_fieldnames.TRANSACTION_URL
    };
    if (searchTerm) {
      urlFilter.wildcards = [searchTerm];
    }
    filters[_elasticsearch_fieldnames.TRANSACTION_URL] = {
      ...urlFilter,
      ...filters[_elasticsearch_fieldnames.TRANSACTION_URL]
    };
  }
  return Object.values(filters);
}