"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMapFilters = void 0;
var _react = require("react");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _index_pattern_constants = require("../../../../../common/index_pattern_constants");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWildcardFilter = (field, value) => {
  return {
    meta: {
      index: _index_pattern_constants.APM_STATIC_INDEX_PATTERN_ID,
      alias: null,
      negate: false,
      disabled: false,
      type: 'term',
      key: field,
      params: {
        query: value
      }
    },
    query: {
      wildcard: {
        [field]: {
          value: `*${value}*`
        }
      }
    }
  };
};
const getMatchFilter = (field, value) => {
  return {
    meta: {
      index: _index_pattern_constants.APM_STATIC_INDEX_PATTERN_ID,
      alias: null,
      negate: false,
      disabled: false,
      type: 'phrase',
      key: field,
      params: {
        query: value
      }
    },
    query: {
      term: {
        [field]: value
      }
    }
  };
};
const getMultiMatchFilter = (field, values, negate = false) => {
  return {
    meta: {
      index: _index_pattern_constants.APM_STATIC_INDEX_PATTERN_ID,
      type: 'phrases',
      key: field,
      value: values.join(', '),
      params: values,
      alias: null,
      negate,
      disabled: false
    },
    query: {
      bool: {
        should: values.map(value => ({
          match_phrase: {
            [field]: value
          }
        })),
        minimum_should_match: 1
      }
    }
  };
};
const existFilter = {
  meta: {
    index: _index_pattern_constants.APM_STATIC_INDEX_PATTERN_ID,
    alias: null,
    negate: false,
    disabled: false,
    type: 'exists',
    key: 'transaction.marks.navigationTiming.fetchStart',
    value: 'exists'
  },
  query: {
    exists: {
      field: 'transaction.marks.navigationTiming.fetchStart'
    }
  }
};
const useMapFilters = () => {
  const {
    urlParams,
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    serviceName,
    searchTerm
  } = urlParams;
  const {
    browser,
    device,
    os,
    location,
    transactionUrl,
    browserExcluded,
    deviceExcluded,
    osExcluded,
    locationExcluded,
    transactionUrlExcluded
  } = uxUiFilters;
  return (0, _react.useMemo)(() => {
    const filters = [existFilter];
    if (serviceName) {
      filters.push(getMatchFilter(_elasticsearch_fieldnames.SERVICE_NAME, serviceName));
    }
    if (browser) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_NAME, browser));
    }
    if (device) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_DEVICE, device));
    }
    if (os) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_OS, os));
    }
    if (location) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_ISO_CODE, location));
    }
    if (transactionUrl) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.TRANSACTION_URL, transactionUrl));
    }
    if (browserExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_NAME, browserExcluded, true));
    }
    if (deviceExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_DEVICE, deviceExcluded, true));
    }
    if (osExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_OS, osExcluded, true));
    }
    if (locationExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_ISO_CODE, locationExcluded, true));
    }
    if (transactionUrlExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.TRANSACTION_URL, transactionUrlExcluded, true));
    }
    if (searchTerm) {
      filters.push(getWildcardFilter(_elasticsearch_fieldnames.TRANSACTION_URL, searchTerm));
    }
    return filters;
  }, [serviceName, browser, device, os, location, transactionUrl, browserExcluded, deviceExcluded, osExcluded, locationExcluded, transactionUrlExcluded, searchTerm]);
};
exports.useMapFilters = useMapFilters;