"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisitorBreakdownLabel = exports.I18LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const I18LABELS = {
  dataMissing: _i18n.i18n.translate('xpack.ux.dashboard.dataMissing', {
    defaultMessage: 'N/A'
  }),
  totalPageLoad: _i18n.i18n.translate('xpack.ux.dashboard.totalPageLoad', {
    defaultMessage: 'Total'
  }),
  backEnd: _i18n.i18n.translate('xpack.ux.dashboard.backend', {
    defaultMessage: 'Backend'
  }),
  frontEnd: _i18n.i18n.translate('xpack.ux.dashboard.frontend', {
    defaultMessage: 'Frontend'
  }),
  pageViews: _i18n.i18n.translate('xpack.ux.dashboard.pageViews', {
    defaultMessage: 'Total page views'
  }),
  percPageLoaded: _i18n.i18n.translate('xpack.ux.dashboard.pagesLoaded.label', {
    defaultMessage: 'Pages loaded'
  }),
  pageLoadTime: _i18n.i18n.translate('xpack.ux.dashboard.pageLoadTime.label', {
    defaultMessage: 'Page load time (seconds)'
  }),
  pageLoadTimes: _i18n.i18n.translate('xpack.ux.dashboard.pageLoadTimes.label', {
    defaultMessage: 'Page load times'
  }),
  pageLoadDuration: _i18n.i18n.translate('xpack.ux.dashboard.pageLoadDuration.label', {
    defaultMessage: 'Page load duration'
  }),
  pageLoad: _i18n.i18n.translate('xpack.ux.dashboard.pageLoad.label', {
    defaultMessage: 'Page load'
  }),
  pageLoadDistribution: _i18n.i18n.translate('xpack.ux.dashboard.pageLoadDistribution.label', {
    defaultMessage: 'Page load distribution'
  }),
  jsErrors: _i18n.i18n.translate('xpack.ux.dashboard.impactfulMetrics.jsErrors', {
    defaultMessage: 'JavaScript errors'
  }),
  highTrafficPages: _i18n.i18n.translate('xpack.ux.dashboard.impactfulMetrics.highTrafficPages', {
    defaultMessage: 'High traffic pages'
  }),
  resetZoom: _i18n.i18n.translate('xpack.ux.dashboard.resetZoom.label', {
    defaultMessage: 'Reset zoom'
  }),
  overall: _i18n.i18n.translate('xpack.ux.dashboard.overall.label', {
    defaultMessage: 'Overall'
  }),
  selectBreakdown: _i18n.i18n.translate('xpack.ux.filterGroup.selectBreakdown', {
    defaultMessage: 'Select breakdown'
  }),
  breakdown: _i18n.i18n.translate('xpack.ux.filterGroup.breakdown', {
    defaultMessage: 'Breakdown'
  }),
  seconds: _i18n.i18n.translate('xpack.ux.filterGroup.seconds', {
    defaultMessage: 'seconds'
  }),
  coreWebVitals: _i18n.i18n.translate('xpack.ux.filterGroup.coreWebVitals', {
    defaultMessage: 'Core web vitals'
  }),
  browser: _i18n.i18n.translate('xpack.ux.visitorBreakdown.browser', {
    defaultMessage: 'Browser'
  }),
  operatingSystem: _i18n.i18n.translate('xpack.ux.visitorBreakdown.operatingSystem', {
    defaultMessage: 'Operating system'
  }),
  metrics: _i18n.i18n.translate('xpack.ux.metrics', {
    defaultMessage: 'Metrics'
  }),
  median: _i18n.i18n.translate('xpack.ux.median', {
    defaultMessage: 'median'
  }),
  avgPageLoadDuration: _i18n.i18n.translate('xpack.ux.visitorBreakdownMap.avgPageLoadDuration', {
    defaultMessage: 'Average page load duration'
  }),
  pageLoadDurationByRegion: _i18n.i18n.translate('xpack.ux.visitorBreakdownMap.pageLoadDurationByRegion', {
    defaultMessage: 'Page load duration by region (avg.)'
  }),
  filterByUrl: _i18n.i18n.translate('xpack.ux.filters.filterByUrl', {
    defaultMessage: 'Filter by URL'
  }),
  getSearchResultsLabel: total => _i18n.i18n.translate('xpack.ux.filters.searchResults', {
    defaultMessage: '{total} Search results',
    values: {
      total
    }
  }),
  topPages: _i18n.i18n.translate('xpack.ux.filters.topPages', {
    defaultMessage: 'Top pages'
  }),
  select: _i18n.i18n.translate('xpack.ux.filters.select', {
    defaultMessage: 'Select'
  }),
  url: _i18n.i18n.translate('xpack.ux.filters.url', {
    defaultMessage: 'Url'
  }),
  loadingResults: _i18n.i18n.translate('xpack.ux.filters.url.loadingResults', {
    defaultMessage: 'Loading results'
  }),
  noResults: _i18n.i18n.translate('xpack.ux.filters.url.noResults', {
    defaultMessage: 'No results available'
  }),
  totalErrors: _i18n.i18n.translate('xpack.ux.jsErrors.totalErrors', {
    defaultMessage: 'Total errors'
  }),
  errorRate: _i18n.i18n.translate('xpack.ux.jsErrors.errorRate', {
    defaultMessage: 'Error rate'
  }),
  errorMessage: _i18n.i18n.translate('xpack.ux.jsErrors.errorMessage', {
    defaultMessage: 'Error message'
  }),
  impactedPageLoads: _i18n.i18n.translate('xpack.ux.jsErrors.impactedPageLoads', {
    defaultMessage: 'Impacted page loads'
  }),
  percentile: _i18n.i18n.translate('xpack.ux.percentile.label', {
    defaultMessage: 'Percentile'
  }),
  percentile50thMedian: _i18n.i18n.translate('xpack.ux.percentile.50thMedian', {
    defaultMessage: '50th (Median)'
  }),
  percentile75th: _i18n.i18n.translate('xpack.ux.percentile.75th', {
    defaultMessage: '75th'
  }),
  percentile90th: _i18n.i18n.translate('xpack.ux.percentile.90th', {
    defaultMessage: '90th'
  }),
  percentile95th: _i18n.i18n.translate('xpack.ux.percentile.95th', {
    defaultMessage: '95th'
  }),
  percentile99th: _i18n.i18n.translate('xpack.ux.percentile.99th', {
    defaultMessage: '99th'
  }),
  noData: _i18n.i18n.translate('xpack.ux.visitorBreakdown.noData', {
    defaultMessage: 'No data.'
  }),
  // Helper tooltips
  totalPageLoadTooltip: _i18n.i18n.translate('xpack.ux.dashboard.tooltips.totalPageLoad', {
    defaultMessage: 'Total represents the full page load duration'
  }),
  frontEndTooltip: _i18n.i18n.translate('xpack.ux.dashboard.tooltips.frontEnd', {
    defaultMessage: 'Frontend time represents the total page load duration minus the backend time'
  }),
  backEndTooltip: _i18n.i18n.translate('xpack.ux.dashboard.tooltips.backEnd', {
    defaultMessage: 'Backend time represents time to first byte (TTFB), which is when the first response packet is received after the request has been made'
  })
};
exports.I18LABELS = I18LABELS;
const VisitorBreakdownLabel = _i18n.i18n.translate('xpack.ux.visitorBreakdown', {
  defaultMessage: 'Visitor breakdown'
});
exports.VisitorBreakdownLabel = VisitorBreakdownLabel;