"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UXAppRoot = UXAppRoot;
exports.uxRoutes = exports.uxRouter = exports.renderApp = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _styledComponents = require("styled-components");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _public3 = require("@kbn/observability-plugin/public");
var _public4 = require("@kbn/observability-shared-plugin/public");
var _csm_shared_context = require("../components/app/rum_dashboard/csm_shared_context");
var _rum_home = require("../components/app/rum_dashboard/rum_home");
var _action_menu = require("../components/app/rum_dashboard/action_menu");
var _url_params_context = require("../context/url_params_context/url_params_context");
var _data_view = require("../services/rest/data_view");
var _create_call_apm_api = require("../services/rest/create_call_apm_api");
var _use_kibana_services = require("../hooks/use_kibana_services");
var _plugin_context = require("../context/plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uxRoutes = [{
  exact: true,
  path: '/',
  render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/ux"
  }),
  breadcrumb: _rum_home.DASHBOARD_LABEL
}];
exports.uxRoutes = uxRoutes;
function UxApp() {
  const [darkMode] = (0, _public2.useUiSetting$)('theme:darkMode');
  const {
    http
  } = (0, _use_kibana_services.useKibanaServices)();
  const basePath = http.basePath.get();
  (0, _public4.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.ux.breadcrumbs.root', {
      defaultMessage: 'User Experience'
    }),
    href: basePath + '/app/ux'
  }, {
    text: _i18n.i18n.translate('xpack.ux.breadcrumbs.dashboard', {
      defaultMessage: 'Dashboard'
    })
  }]);
  return /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, {
    theme: outerTheme => ({
      ...outerTheme,
      eui: darkMode ? _uiTheme.euiDarkVars : _uiTheme.euiLightVars,
      darkMode
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": "csmMainContainer"
  }, /*#__PURE__*/_react.default.createElement(_rum_home.RumHome, null)));
}
const uxRouter = (0, _typedReactRouterConfig.createRouter)({});
exports.uxRouter = uxRouter;
function UXAppRoot({
  appMountParameters,
  core,
  deps,
  corePlugins: {
    embeddable,
    inspector,
    maps,
    observability,
    observabilityShared,
    observabilityAIAssistant,
    exploratoryView,
    data,
    dataViews,
    lens
  },
  isDev
}) {
  const {
    history
  } = appMountParameters;
  const i18nCore = core.i18n;
  const plugins = {
    ...deps,
    maps
  };
  (0, _create_call_apm_api.createCallApmApi)(core);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: core.application
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      inspector,
      observability,
      observabilityShared,
      observabilityAIAssistant,
      embeddable,
      exploratoryView,
      data,
      dataViews,
      lens
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
    theme$: appMountParameters.theme$,
    modify: {
      breakpoint: {
        xxl: 1600,
        xxxl: 2000
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
    value: {
      appMountParameters,
      exploratoryView,
      observabilityShared
    }
  }, /*#__PURE__*/_react.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: uxRouter
  }, /*#__PURE__*/_react.default.createElement(_public3.DatePickerContextProvider, null, /*#__PURE__*/_react.default.createElement(_public4.InspectorContextProvider, null, /*#__PURE__*/_react.default.createElement(_url_params_context.UrlParamsProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_csm_shared_context.CsmSharedContextProvider, null, /*#__PURE__*/_react.default.createElement(UxApp, null))), /*#__PURE__*/_react.default.createElement(_action_menu.UXActionMenu, {
    appMountParameters: appMountParameters,
    isDev: isDev
  })))))))))));
}

/**
 * This module is rendered asynchronously in the Kibana platform.
 */

const renderApp = ({
  core,
  deps,
  appMountParameters,
  corePlugins,
  isDev
}) => {
  const {
    element
  } = appMountParameters;
  (0, _create_call_apm_api.createCallApmApi)(core);

  // Automatically creates static data view and stores as saved object
  (0, _data_view.createStaticDataView)().catch(e => {
    // eslint-disable-next-line no-console
    console.log('Error creating static data view', e);
  });
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(UXAppRoot, {
    appMountParameters: appMountParameters,
    core: core,
    deps: deps,
    corePlugins: corePlugins,
    isDev: isDev
  }), element);
  return () => {
    corePlugins.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;