"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrackApplicationViewComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class TrackApplicationViewComponent extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "parentNode", void 0);
    (0, _defineProperty2.default)(this, "onClick", e => {
      var _ReactDOM$findDOMNode, _this$parentNode;
      const {
        applicationUsageTracker,
        viewId
      } = this.props;
      this.parentNode = this.parentNode || ((_ReactDOM$findDOMNode = _reactDom.default.findDOMNode(this)) === null || _ReactDOM$findDOMNode === void 0 ? void 0 : _ReactDOM$findDOMNode.parentNode);
      if (this.parentNode === e.target || (_this$parentNode = this.parentNode) !== null && _this$parentNode !== void 0 && _this$parentNode.contains(e.target)) {
        applicationUsageTracker === null || applicationUsageTracker === void 0 ? void 0 : applicationUsageTracker.updateViewClickCounter(viewId);
      }
    });
  }
  componentDidMount() {
    const {
      applicationUsageTracker,
      viewId
    } = this.props;
    if (applicationUsageTracker) {
      applicationUsageTracker.trackApplicationViewUsage(viewId);
      document.addEventListener('click', this.onClick);
    }
  }
  componentWillUnmount() {
    const {
      applicationUsageTracker,
      viewId
    } = this.props;
    if (applicationUsageTracker) {
      applicationUsageTracker.flushTrackedView(viewId);
    }
    document.removeEventListener('click', this.onClick);
  }
  render() {
    return this.props.children;
  }
}
exports.TrackApplicationViewComponent = TrackApplicationViewComponent;