"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_IN_APP_URL = exports.MESSAGE = exports.ALERT_REASON_MSG = exports.ALERT_DETAILS_URL = exports.ACTION_VARIABLES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MESSAGE = 'message';
exports.MESSAGE = MESSAGE;
const ALERT_REASON_MSG = 'reason';
exports.ALERT_REASON_MSG = ALERT_REASON_MSG;
const ALERT_DETAILS_URL = 'alertDetailsUrl';
exports.ALERT_DETAILS_URL = ALERT_DETAILS_URL;
const VIEW_IN_APP_URL = 'viewInAppUrl';
exports.VIEW_IN_APP_URL = VIEW_IN_APP_URL;
const ACTION_VARIABLES = {
  [MESSAGE]: {
    name: MESSAGE,
    description: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.actionVariables.context.message.description', {
      defaultMessage: 'A generated message summarizing the currently down monitors'
    })
  },
  [ALERT_REASON_MSG]: {
    name: ALERT_REASON_MSG,
    description: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.actionVariables.context.alertReasonMessage.description', {
      defaultMessage: 'A concise description of the reason for the alert'
    })
  },
  [ALERT_DETAILS_URL]: {
    name: ALERT_DETAILS_URL,
    description: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.actionVariables.context.alertDetailUrl.description', {
      defaultMessage: 'Link to the alert troubleshooting view for further context and details. This will be an empty string if the server.publicBaseUrl is not configured.'
    }),
    usesPublicBaseUrl: true
  },
  [VIEW_IN_APP_URL]: {
    name: VIEW_IN_APP_URL,
    description: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.actionVariables.context.viewInAppUrl.description', {
      defaultMessage: 'Link to the alert source'
    }),
    usesPublicBaseUrl: true
  }
};
exports.ACTION_VARIABLES = ACTION_VARIABLES;