"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resetMLState = exports.getMLCapabilitiesAction = exports.getExistingMLJobAction = exports.getAnomalyRecordsAction = exports.deleteMLJobAction = exports.createMLJobAction = void 0;
var _reduxActions = require("redux-actions");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resetMLState = (0, _reduxActions.createAction)('RESET_ML_STATE');
exports.resetMLState = resetMLState;
const getExistingMLJobAction = (0, _utils.createAsyncAction)('GET_EXISTING_ML_JOB');
exports.getExistingMLJobAction = getExistingMLJobAction;
const createMLJobAction = (0, _utils.createAsyncAction)('CREATE_ML_JOB');
exports.createMLJobAction = createMLJobAction;
const getMLCapabilitiesAction = (0, _utils.createAsyncAction)('GET_ML_CAPABILITIES');
exports.getMLCapabilitiesAction = getMLCapabilitiesAction;
const deleteMLJobAction = (0, _utils.createAsyncAction)('DELETE_ML_JOB');
exports.deleteMLJobAction = deleteMLJobAction;
const getAnomalyRecordsAction = (0, _utils.createAsyncAction)('GET_ANOMALY_RECORDS');
exports.getAnomalyRecordsAction = getAnomalyRecordsAction;