"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRealStore = exports.MountWithReduxProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _reduxSaga = _interopRequireDefault(require("redux-saga"));
var _reducers = require("../../state/reducers");
var _effects = require("../../state/effects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRealStore = () => {
  const sagaMW = (0, _reduxSaga.default)();
  const store = (0, _redux.createStore)(_reducers.rootReducer, (0, _redux.applyMiddleware)(sagaMW));
  sagaMW.run(_effects.rootEffect);
  return store;
};
exports.createRealStore = createRealStore;
const MountWithReduxProvider = ({
  children,
  state,
  store,
  useRealStore
}) => {
  const newStore = useRealStore ? createRealStore() : {
    dispatch: jest.fn(),
    getState: jest.fn().mockReturnValue(state || {
      selectedFilters: null
    }),
    subscribe: jest.fn(),
    replaceReducer: jest.fn(),
    [Symbol.observable]: jest.fn()
  };
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store !== null && store !== void 0 ? store : newStore
  }, children);
};
exports.MountWithReduxProvider = MountWithReduxProvider;