"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeExpLabels = exports.statusExpLabels = exports.filterAriaLabels = exports.alertFilterLabels = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertFilterLabels = {
  USING: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.using', {
    defaultMessage: 'Using'
  }),
  USING_PORT: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.usingPort', {
    defaultMessage: 'Using port'
  }),
  ANY_PORT: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.anyPort', {
    defaultMessage: 'any port'
  }),
  WITH: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.with', {
    defaultMessage: 'Using'
  }),
  WITH_TAG: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.withTag', {
    defaultMessage: 'With tag'
  }),
  ANY_TAG: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.anyTag', {
    defaultMessage: 'any tag'
  }),
  OF: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.of', {
    defaultMessage: 'Of'
  }),
  OF_TYPE: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.ofType', {
    defaultMessage: 'Of type'
  }),
  ANY_TYPE: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.anyType', {
    defaultMessage: 'any type'
  }),
  FROM: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.from', {
    defaultMessage: 'From'
  }),
  FROM_LOCATION: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.fromLocation', {
    defaultMessage: 'From location'
  }),
  ANY_LOCATION: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.anyLocation', {
    defaultMessage: 'any location'
  }),
  REMOVE_FILTER_LABEL: title => _i18n.i18n.translate('xpack.uptime.alerts.monitorExpression.label', {
    defaultMessage: 'Remove filter {title}',
    values: {
      title
    }
  })
};
exports.alertFilterLabels = alertFilterLabels;
const statusExpLabels = {
  ENABLED_CHECKBOX: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.statusEnabledCheck.label', {
    defaultMessage: 'Status check'
  })
};
exports.statusExpLabels = statusExpLabels;
const timeExpLabels = {
  OPEN_TIME_POPOVER: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeUnitExpression.ariaLabel', {
    defaultMessage: 'Open the popover for time range unit select field'
  }),
  SELECT_TIME_RANGE_ARIA: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeUnitSelectable', {
    defaultMessage: 'Selectable field for the time range units alerts should use'
  }),
  SELECT_TIME_RANGE_HEADLINE: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeSelectionHeader', {
    defaultMessage: 'Select time range unit'
  })
};
exports.timeExpLabels = timeExpLabels;
const filterAriaLabels = {
  PORT: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.port.label', {
    defaultMessage: `Select port filters to apply to the alert's query.`
  }),
  TAG: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.tag.label', {
    defaultMessage: `Select tag filters to apply to the alert's query.`
  }),
  SCHEME: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.scheme.label', {
    defaultMessage: `Select protocol scheme filters to apply to the alert's query.`
  }),
  LOCATION: _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filters.location.label', {
    defaultMessage: `Select location filters to apply to the alert's query.`
  })
};
exports.filterAriaLabels = filterAriaLabels;