"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeExpressionSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alert_expression_popover = require("../alert_expression_popover");
var labels = _interopRequireWildcard(require("../translations"));
var _alert_field_number = require("../alert_field_number");
var _translations2 = require("./translations");
var _time_unit_selectable = require("./time_unit_selectable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TIMERANGE_UNIT = 'm';
const TimeRangeOptions = [{
  'aria-label': labels.SECONDS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable.secondsOption',
  key: 's',
  label: labels.SECONDS
}, {
  'aria-label': labels.MINUTES_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable.minutesOption',
  key: 'm',
  label: labels.MINUTES
}, {
  'aria-label': labels.HOURS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable.hoursOption',
  key: 'h',
  label: labels.HOURS
}, {
  'aria-label': labels.DAYS_TIME_RANGE,
  'data-test-subj': 'xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable.daysOption',
  key: 'd',
  label: labels.DAYS
}];
const TimeExpressionSelect = ({
  defaultTimerangeCount,
  defaultTimerangeUnit,
  isEnabled,
  setRuleParams
}) => {
  var _timerangeUnitOptions3, _timerangeUnitOptions4;
  const [numUnits, setNumUnits] = (0, _react.useState)(defaultTimerangeCount !== null && defaultTimerangeCount !== void 0 ? defaultTimerangeCount : 15);
  const [timerangeUnitOptions, setTimerangeUnitOptions] = (0, _react.useState)(TimeRangeOptions.map(opt => opt.key === (defaultTimerangeUnit !== null && defaultTimerangeUnit !== void 0 ? defaultTimerangeUnit : DEFAULT_TIMERANGE_UNIT) ? {
    ...opt,
    checked: 'on'
  } : opt));
  (0, _react.useEffect)(() => {
    var _timerangeUnitOptions, _timerangeUnitOptions2;
    const timerangeUnit = (_timerangeUnitOptions = (_timerangeUnitOptions2 = timerangeUnitOptions.find(({
      checked
    }) => checked === 'on')) === null || _timerangeUnitOptions2 === void 0 ? void 0 : _timerangeUnitOptions2.key) !== null && _timerangeUnitOptions !== void 0 ? _timerangeUnitOptions : 'm';
    setRuleParams('timerangeUnit', timerangeUnit);
    setRuleParams('timerangeCount', numUnits);
  }, [numUnits, timerangeUnitOptions, setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": labels.OPEN_THE_POPOVER_TIME_RANGE_VALUE,
    content: /*#__PURE__*/_react.default.createElement(_alert_field_number.AlertFieldNumber, {
      "aria-label": labels.ENTER_NUMBER_OF_TIME_UNITS,
      "data-test-subj": "xpack.synthetics.alerts.monitorStatus.timerangeValueField",
      disabled: false,
      fieldValue: numUnits,
      setFieldValue: setNumUnits
    }),
    "data-test-subj": "xpack.synthetics.alerts.monitorStatus.timerangeValueExpression",
    description: labels.ENTER_NUMBER_OF_TIME_UNITS_DESCRIPTION,
    id: "timerange",
    isEnabled: isEnabled,
    value: labels.ENTER_NUMBER_OF_TIME_UNITS_VALUE(numUnits)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": _translations2.timeExpLabels.OPEN_TIME_POPOVER,
    content: /*#__PURE__*/_react.default.createElement(_time_unit_selectable.TimeUnitSelectable, {
      "aria-label": _translations2.timeExpLabels.SELECT_TIME_RANGE_ARIA,
      "data-test-subj": "xpack.synthetics.alerts.monitorStatus.timerangeUnitSelectable",
      headlineText: _translations2.timeExpLabels.SELECT_TIME_RANGE_HEADLINE,
      onChange: newOptions => {
        if (newOptions.reduce((acc, {
          checked
        }) => acc || checked === 'on', false)) {
          setTimerangeUnitOptions(newOptions);
        }
      },
      timeRangeOptions: timerangeUnitOptions
    }),
    "data-test-subj": "xpack.synthetics.alerts.monitorStatus.timerangeUnitExpression",
    description: "",
    id: "timerange-unit",
    isEnabled: isEnabled,
    value: (_timerangeUnitOptions3 = (_timerangeUnitOptions4 = timerangeUnitOptions.find(({
      checked
    }) => checked === 'on')) === null || _timerangeUnitOptions4 === void 0 ? void 0 : _timerangeUnitOptions4.label.toLowerCase()) !== null && _timerangeUnitOptions3 !== void 0 ? _timerangeUnitOptions3 : ''
  })));
};
exports.TimeExpressionSelect = TimeExpressionSelect;