"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAvailabilityValue = exports.AvailabilityReporting = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _tag_label = require("./tag_label");
var _translations = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatAvailabilityValue = val => {
  const result = Math.round(val * 100) / 100;
  return result.toFixed(2);
};
exports.formatAvailabilityValue = formatAvailabilityValue;
const AvailabilityReporting = ({
  allLocations
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const cols = [{
    field: 'label',
    name: _translations.LocationLabel,
    truncateText: true,
    render: (val, item) => {
      return /*#__PURE__*/_react.default.createElement(_tag_label.TagLabel, item);
    }
  }, {
    field: 'availability',
    name: _translations.AvailabilityLabel,
    align: 'right',
    render: val => {
      return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.uptime.availabilityLabelText",
        defaultMessage: "{value} %",
        values: {
          value: formatAvailabilityValue(val)
        },
        description: "A percentage value, like 23.5%"
      }));
    }
  }, {
    name: _translations.LastCheckLabel,
    field: 'timestamp',
    align: 'right'
  }];
  const pageSize = 5;
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: allLocations.length,
    showPerPageOptions: false
  };
  const onTableChange = ({
    page
  }) => {
    var _page$index;
    setPageIndex((_page$index = page === null || page === void 0 ? void 0 : page.index) !== null && _page$index !== void 0 ? _page$index : 0);
  };
  const paginationProps = allLocations.length > pageSize ? {
    pagination
  } : {};
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({
    responsive: false,
    compressed: true,
    columns: cols,
    items: allLocations.slice(pageIndex * pageSize, pageIndex * pageSize + pageSize),
    onChange: onTableChange
  }, paginationProps)));
};
exports.AvailabilityReporting = AvailabilityReporting;