"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingHistogram = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _charts = require("../../common/charts");
var _actions = require("../../../state/actions");
var _selectors = require("../../../state/selectors");
var _hooks = require("../../../hooks");
var _higher_order = require("../../common/higher_order");
var _contexts = require("../../../contexts");
var _use_overview_filter_check = require("../../../hooks/use_overview_filter_check");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = ({
  height
}) => {
  const {
    query,
    absoluteDateRangeStart,
    absoluteDateRangeEnd,
    dateRangeStart: dateStart,
    dateRangeEnd: dateEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    filterCheck,
    pending
  } = (0, _use_overview_filter_check.useOverviewFilterCheck)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const monitorId = (0, _hooks.useMonitorId)();
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const esKuery = (0, _reactRedux.useSelector)(_selectors.esKuerySelector);
  const {
    loading,
    pingHistogram: data
  } = (0, _reactRedux.useSelector)(_selectors.selectPingHistogram);
  const timeZone = (0, _public.useTimeZone)();
  (0, _react.useEffect)(() => {
    if (monitorId) {
      // we don't need filter check on monitor details page, where we have monitorId defined
      dispatch(_actions.getPingHistogram.get({
        monitorId,
        dateStart,
        dateEnd,
        query,
        filters: esKuery,
        timeZone
      }));
    } else {
      filterCheck(() => dispatch(_actions.getPingHistogram.get({
        monitorId,
        dateStart,
        dateEnd,
        query,
        filters: esKuery,
        timeZone
      })));
    }
  }, [filterCheck, dateStart, dateEnd, monitorId, lastRefresh, esKuery, dispatch, query, timeZone]);
  return /*#__PURE__*/_react.default.createElement(_charts.PingHistogramComponent, {
    data: data,
    absoluteStartDate: absoluteDateRangeStart,
    absoluteEndDate: absoluteDateRangeEnd,
    height: height,
    loading: loading || pending,
    timeZone: timeZone
  });
};
const PingHistogram = (0, _higher_order.withResponsiveWrapper)(Container);
exports.PingHistogram = PingHistogram;