"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withResponsiveWrapper = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponsiveWrapper = _styledComponents.default.div`
  margin-left: 120px;
  @media (max-width: 950px) {
    margin-left: 48px;
  }
  @media (max-width: 767px) {
    margin-left: 12px;
    margin-top: 40px;
  }
`;
/**
 * HOC that wraps a component in either a responsive div or an EuiPanel.
 * @param Component The component to wrap.
 */
const withResponsiveWrapper = Component => ({
  isResponsive,
  ...rest
}) => isResponsive ? /*#__PURE__*/_react.default.createElement(ResponsiveWrapper, {
  "data-test-subj": "uptimeWithResponsiveWrapper--wrapper"
}, /*#__PURE__*/_react.default.createElement(Component, rest)) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  paddingSize: "m",
  hasBorder: true,
  "data-test-subj": "uptimeWithResponsiveWrapper--panel"
}, /*#__PURE__*/_react.default.createElement(Component, rest));
exports.withResponsiveWrapper = withResponsiveWrapper;