"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimeApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _common = require("@kbn/kibana-react-plugin/common");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _contexts = require("../contexts");
var _actions = require("../state/actions");
var _routes = require("../routes");
var _overview = require("../components/overview");
var _state = require("../state");
var _kibana_service = require("../state/kibana_service");
var _action_menu = require("../components/common/header/action_menu");
var _uptime_data_view_context = require("../contexts/uptime_data_view_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Application = props => {
  const {
    basePath,
    canSave,
    core,
    darkMode,
    i18n: i18nCore,
    plugins,
    renderGlobalHelpControls,
    setBadge,
    startPlugins,
    appMountParameters
  } = props;
  (0, _react.useEffect)(() => {
    renderGlobalHelpControls();
    setBadge(!canSave ? {
      text: _i18n.i18n.translate('xpack.uptime.badge.readOnly.text', {
        defaultMessage: 'Read only'
      }),
      tooltip: _i18n.i18n.translate('xpack.uptime.badge.readOnly.tooltip', {
        defaultMessage: 'Unable to save'
      }),
      iconType: 'glasses'
    } : undefined);
  }, [canSave, renderGlobalHelpControls, setBadge]);
  _kibana_service.kibanaService.core = core;
  _kibana_service.kibanaService.theme = props.appMountParameters.theme$;
  _state.store.dispatch((0, _actions.setBasePath)(basePath));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
    theme$: props.appMountParameters.theme$,
    modify: {
      breakpoint: {
        xxl: 1600,
        xxxl: 2000
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _state.store
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage: _state.storage,
      data: startPlugins.data,
      fleet: startPlugins.fleet,
      inspector: startPlugins.inspector,
      triggersActionsUi: startPlugins.triggersActionsUi,
      observability: startPlugins.observability,
      observabilityShared: startPlugins.observabilityShared,
      exploratoryView: startPlugins.exploratoryView,
      cases: startPlugins.cases
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: appMountParameters.history
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: darkMode
  }, /*#__PURE__*/_react.default.createElement(_contexts.UptimeRefreshContextProvider, null, /*#__PURE__*/_react.default.createElement(_contexts.UptimeSettingsContextProvider, props, /*#__PURE__*/_react.default.createElement(_contexts.UptimeThemeContextProvider, {
    darkMode: darkMode
  }, /*#__PURE__*/_react.default.createElement(_contexts.UptimeStartupPluginsContextProvider, startPlugins, /*#__PURE__*/_react.default.createElement(_uptime_data_view_context.UptimeDataViewContextProvider, {
    dataViews: startPlugins.dataViews
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": "uptimeApp"
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: core.application
    }
  }, /*#__PURE__*/_react.default.createElement(_public3.InspectorContextProvider, null, /*#__PURE__*/_react.default.createElement(_overview.UptimeAlertsFlyoutWrapper, null), /*#__PURE__*/_react.default.createElement(_routes.PageRouter, null), /*#__PURE__*/_react.default.createElement(_action_menu.ActionMenu, {
    appMountParameters: appMountParameters
  }))))))))))))))));
};
const UptimeApp = props => /*#__PURE__*/_react.default.createElement(Application, props);
exports.UptimeApp = UptimeApp;