"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlSnapshotsResolutionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  upgradeInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeInProgressText', {
    defaultMessage: 'Upgrade in progress…'
  }),
  deleteInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.deletingButtonLabel', {
    defaultMessage: 'Deletion in progress…'
  }),
  upgradeCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeCompleteText', {
    defaultMessage: 'Upgrade complete'
  }),
  deleteCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.deleteCompleteText', {
    defaultMessage: 'Deletion complete'
  }),
  upgradeFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeFailedText', {
    defaultMessage: 'Upgrade failed'
  }),
  deleteFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.deleteFailedText', {
    defaultMessage: 'Deletion failed'
  }),
  resolutionText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.resolutionText', {
    defaultMessage: 'Upgrade or delete snapshots'
  }),
  resolutionTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.resolutionTooltipLabel', {
    defaultMessage: 'Resolve this issue by upgrading or deleting a job model snapshot. This issue can be resolved automatically.'
  })
};
const MlSnapshotsResolutionCell = () => {
  const {
    snapshotState
  } = (0, _context.useMlSnapshotContext)();
  if (snapshotState.status === 'in_progress') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "mlActionResolutionCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, snapshotState.action === 'delete' ? i18nTexts.deleteInProgressText : i18nTexts.upgradeInProgressText)));
  }
  if (snapshotState.status === 'complete') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "mlActionResolutionCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      color: "success"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, snapshotState.action === 'delete' ? i18nTexts.deleteCompleteText : i18nTexts.upgradeCompleteText)));
  }
  if (snapshotState.status === 'error') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "mlActionResolutionCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, snapshotState.action === 'delete' ? i18nTexts.deleteFailedText : i18nTexts.upgradeFailedText)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18nTexts.resolutionTooltipLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": "mlActionResolutionCell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "indexSettings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i18nTexts.resolutionText))));
};
exports.MlSnapshotsResolutionCell = MlSnapshotsResolutionCell;