"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterManager = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useFilterManager = props => {
  // Filters should be either what's passed in the initial state or the current state of the filter manager
  const [filters, setFilters] = (0, _react.useState)(props.filters || props.filterManager.getFilters());
  (0, _react.useEffect)(() => {
    const subscriptions = new _rxjs.Subscription();
    subscriptions.add(props.filterManager.getUpdates$().subscribe({
      next: () => {
        const newFilters = props.filterManager.getFilters();
        setFilters(newFilters);
      }
    }));
    return () => {
      subscriptions.unsubscribe();
    };
  }, [props.filterManager]);
  return {
    filters
  };
};
exports.useFilterManager = useFilterManager;