"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedQueryManagementList = SavedQueryManagementList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
require("./saved_query_management_list.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const commonDurationRanges = [{
  start: 'now/d',
  end: 'now/d',
  label: 'Today'
}, {
  start: 'now/w',
  end: 'now/w',
  label: 'This week'
}, {
  start: 'now/M',
  end: 'now/M',
  label: 'This month'
}, {
  start: 'now/y',
  end: 'now/y',
  label: 'This year'
}, {
  start: 'now-1d/d',
  end: 'now-1d/d',
  label: 'Yesterday'
}, {
  start: 'now/w',
  end: 'now',
  label: 'Week to date'
}, {
  start: 'now/M',
  end: 'now',
  label: 'Month to date'
}, {
  start: 'now/y',
  end: 'now',
  label: 'Year to date'
}];
const itemTitle = (attributes, format) => {
  let label = attributes.title;
  const prettifier = _eui.usePrettyDuration;
  if (attributes.description) {
    label += `; ${attributes.description}`;
  }
  if (attributes.timefilter) {
    var _attributes$timefilte, _attributes$timefilte2;
    label += `; ${prettifier({
      timeFrom: (_attributes$timefilte = attributes.timefilter) === null || _attributes$timefilte === void 0 ? void 0 : _attributes$timefilte.from,
      timeTo: (_attributes$timefilte2 = attributes.timefilter) === null || _attributes$timefilte2 === void 0 ? void 0 : _attributes$timefilte2.to,
      quickRanges: commonDurationRanges,
      dateFormat: format
    })}`;
  }
  return label;
};
const itemLabel = attributes => {
  let label = attributes.title;
  if (attributes.description) {
    label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle",
      color: "subdued",
      size: "s"
    }));
  }
  if (attributes.timefilter) {
    label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "clock",
      color: "subdued",
      size: "s"
    }));
  }
  return label;
};
function SavedQueryManagementList({
  showSaveQuery,
  loadedSavedQuery,
  onLoad,
  onClearSavedQuery,
  savedQueryService,
  onClose,
  hasFiltersOrQuery
}) {
  const kibana = (0, _public.useKibana)();
  const [savedQueries, setSavedQueries] = (0, _react.useState)([]);
  const [selectedSavedQuery, setSelectedSavedQuery] = (0, _react.useState)(loadedSavedQuery);
  const [toBeDeletedSavedQuery, setToBeDeletedSavedQuery] = (0, _react.useState)(null);
  const [showDeletionConfirmationModal, setShowDeletionConfirmationModal] = (0, _react.useState)(false);
  const cancelPendingListingRequest = (0, _react.useRef)(() => {});
  const {
    uiSettings,
    http,
    application
  } = kibana.services;
  const format = uiSettings.get('dateFormat');
  (0, _react.useEffect)(() => {
    const fetchCountAndSavedQueries = async () => {
      cancelPendingListingRequest.current();
      let requestGotCancelled = false;
      cancelPendingListingRequest.current = () => {
        requestGotCancelled = true;
      };
      const savedQueryItems = await savedQueryService.getAllSavedQueries();
      if (requestGotCancelled) return;
      const sortedSavedQueryItems = (0, _lodash.sortBy)(savedQueryItems, 'attributes.title');
      setSavedQueries(sortedSavedQueryItems);
    };
    fetchCountAndSavedQueries();
  }, [savedQueryService]);
  const handleLoad = (0, _react.useCallback)(() => {
    if (selectedSavedQuery) {
      onLoad(selectedSavedQuery);
      onClose();
    }
  }, [onLoad, selectedSavedQuery, onClose]);
  const handleSelect = (0, _react.useCallback)(savedQueryToSelect => {
    setSelectedSavedQuery(savedQueryToSelect);
  }, []);
  const handleDelete = (0, _react.useCallback)(savedQueryToDelete => {
    setShowDeletionConfirmationModal(true);
    setToBeDeletedSavedQuery(savedQueryToDelete);
  }, []);
  const onDelete = (0, _react.useCallback)(savedQueryToDelete => {
    const onDeleteSavedQuery = async savedQueryId => {
      cancelPendingListingRequest.current();
      setSavedQueries(savedQueries.filter(currentSavedQuery => currentSavedQuery.id !== savedQueryId));
      if (loadedSavedQuery && loadedSavedQuery.id === savedQueryId) {
        onClearSavedQuery();
        setSelectedSavedQuery(undefined);
      }
      await savedQueryService.deleteSavedQuery(savedQueryId);
    };
    onDeleteSavedQuery(savedQueryToDelete);
  }, [loadedSavedQuery, onClearSavedQuery, savedQueries, savedQueryService]);
  const savedQueryDescriptionText = _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryDescriptionText', {
    defaultMessage: 'Save query text and filters that you want to use again.'
  });
  const noSavedQueriesDescriptionText = _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryNoSavedQueriesText', {
    defaultMessage: 'No saved queries.'
  }) + ' ' + savedQueryDescriptionText;
  const savedQueryMultipleNamespacesDeleteWarning = _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryMultipleNamespacesDeleteWarning', {
    defaultMessage: `This saved query is shared in multiple spaces. When you delete it, you remove it from every space it is shared in. You can't undo this action.`
  });
  const savedQueriesOptions = () => {
    const savedQueriesWithoutCurrent = savedQueries.filter(savedQuery => {
      if (!loadedSavedQuery) return true;
      return savedQuery.id !== loadedSavedQuery.id;
    });
    const savedQueriesReordered = loadedSavedQuery && savedQueriesWithoutCurrent.length !== savedQueries.length ? [loadedSavedQuery, ...savedQueriesWithoutCurrent] : [...savedQueriesWithoutCurrent];
    return savedQueriesReordered.map(savedQuery => {
      return {
        key: savedQuery.id,
        label: savedQuery.attributes.title,
        title: itemTitle(savedQuery.attributes, format),
        'data-test-subj': `load-saved-query-${savedQuery.attributes.title}-button`,
        value: savedQuery.id,
        checked: selectedSavedQuery && savedQuery.id === selectedSavedQuery.id ? 'on' : undefined,
        data: {
          attributes: savedQuery.attributes
        },
        append: !!showSaveQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          css: (0, _react2.css)`
              opacity: 0.2;
              filter: grayscale(100%);

              &:hover,
              &:focus:focus-visible {
                opacity: 1;
                filter: grayscale(0%);
              }
            `,
          iconType: "trash",
          "aria-label": `Delete ${savedQuery.attributes.title}`,
          "data-test-subj": `delete-saved-query-${savedQuery.attributes.title}-button`,
          title: `Delete ${savedQuery.attributes.title}`,
          onClick: () => handleDelete(savedQuery),
          color: "danger"
        })
      };
    });
  };
  const renderOption = option => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, option.attributes ? itemLabel(option.attributes) : option.label);
  };
  const canEditSavedObjects = application.capabilities.savedObjectsManagement.edit;
  const listComponent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, savedQueries.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnSavedQueryManagement__listWrapper",
    "data-test-subj": "saved-query-management-list"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": "Basic example",
    options: savedQueriesOptions(),
    searchable: true,
    singleSelection: "always",
    onChange: choices => {
      const choice = choices.find(({
        checked
      }) => checked);
      if (choice) {
        handleSelect(savedQueries.find(savedQuery => savedQuery.id === choice.value));
      }
    },
    searchProps: {
      compressed: true,
      placeholder: _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.findFilterSet', {
        defaultMessage: 'Find a query'
      })
    },
    listProps: {
      isVirtualized: true
    },
    renderOption: renderOption
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      paddingBottom: 0
    },
    color: "transparent",
    paddingSize: "s"
  }, search), list)))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    className: "kbnSavedQueryManagement__text",
    "data-test-subj": "saved-query-management-empty"
  }, /*#__PURE__*/_react.default.createElement("p", null, noSavedQueriesDescriptionText))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fill: true,
    onClick: handleLoad,
    disabled: !selectedSavedQuery,
    "aria-label": _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverApplyFilterSetLabel', {
      defaultMessage: 'Load query'
    }),
    "data-test-subj": "saved-query-management-apply-changes-button"
  }, _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverApplyFilterSetLabel', {
    defaultMessage: 'Load query'
  }))), canEditSavedObjects && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: http.basePath.prepend(`/app/management/kibana/objects?initialQuery=type:("query")`),
    size: "s"
  }, _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverManageLabel', {
    defaultMessage: 'Manage saved objects'
  }))))), showDeletionConfirmationModal && toBeDeletedSavedQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverConfirmDeletionTitle', {
      defaultMessage: 'Delete "{savedQueryName}"?',
      values: {
        savedQueryName: toBeDeletedSavedQuery.attributes.title
      }
    }),
    confirmButtonText: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverConfirmDeletionConfirmButtonText', {
      defaultMessage: 'Delete'
    }),
    cancelButtonText: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverConfirmDeletionCancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    onConfirm: () => {
      onDelete(toBeDeletedSavedQuery.id);
      setShowDeletionConfirmationModal(false);
    },
    buttonColor: "danger",
    onCancel: () => {
      setShowDeletionConfirmationModal(false);
    }
  }, toBeDeletedSavedQuery.namespaces.length > 1 || toBeDeletedSavedQuery.namespaces.includes('*') ? savedQueryMultipleNamespacesDeleteWarning : null));
  return listComponent;
}