"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersBuilderReducer = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal **/

/** @internal **/

/** @internal **/

/** @internal **/

/** @internal **/

/** @internal **/

/** @internal **/

const FiltersBuilderReducer = (state, action) => {
  switch (action.type) {
    case 'updateFilters':
      return {
        ...state,
        filters: action.payload.filters
      };
    case 'addFilter':
      return {
        ...state,
        filters: (0, _utils.addFilter)(state.filters, action.payload.filter, action.payload.dest, action.payload.booleanRelation, action.payload.dataView)
      };
    case 'removeFilter':
      return {
        ...state,
        filters: (0, _utils.removeFilter)(state.filters, action.payload.dest)
      };
    case 'moveFilter':
      return {
        ...state,
        filters: (0, _utils.moveFilter)(state.filters, action.payload.from, action.payload.to, action.payload.booleanRelation, action.payload.dataView)
      };
    case 'updateFilter':
      return {
        ...state,
        filters: (0, _utils.updateFilters)(state.filters, action.payload.dest, action.payload.field, action.payload.operator, action.payload.params)
      };
    default:
      throw new Error('wrong action');
  }
};
exports.FiltersBuilderReducer = FiltersBuilderReducer;