"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withCloseFilterEditorConfirmModal = withCloseFilterEditorConfirmModal;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _esQuery = require("@kbn/es-query");
var _react = _interopRequireWildcard(require("react"));
var _close_confirm_modal = require("./close_confirm_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isQueryDslFilter = filter => {
  return 'queryDsl' in filter && 'customLabel' in filter;
};
const isQueryDslFilterChanged = (original, updated) => original.queryDsl !== updated.queryDsl || original.customLabel !== updated.customLabel;
function withCloseFilterEditorConfirmModal(WrappedComponent) {
  return function (props) {
    const [actionsOnClose, setActionsOnClose] = (0, _react.useState)();
    const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
    const [updatedFilter, setUpdatedFilter] = (0, _react.useState)();
    const [originalFilter, setOriginalFilter] = (0, _react.useState)();
    const onCancelModal = (0, _react.useCallback)(() => {
      setShowConfirmModal(false);
    }, [setShowConfirmModal]);
    const onConfirmModal = (0, _react.useCallback)(() => {
      setShowConfirmModal(false);
      actionsOnClose === null || actionsOnClose === void 0 ? void 0 : actionsOnClose.map(action => action());
    }, [actionsOnClose, setShowConfirmModal]);
    const onCloseFilterPopover = (0, _react.useCallback)(actions => {
      const filtersAreNotEqual = updatedFilter && originalFilter && (isQueryDslFilter(updatedFilter) && isQueryDslFilterChanged(originalFilter.queryDslFilter, updatedFilter) || !isQueryDslFilter(updatedFilter) && !(0, _esQuery.compareFilters)(originalFilter.filter, updatedFilter, {
        index: true,
        alias: true
      }));
      if (filtersAreNotEqual) {
        setShowConfirmModal(true);
        setActionsOnClose(actions);
      } else {
        actions === null || actions === void 0 ? void 0 : actions.map(action => action());
      }
    }, [originalFilter, updatedFilter, setShowConfirmModal, setActionsOnClose]);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, props, {
      onCloseFilterPopover: onCloseFilterPopover,
      onLocalFilterCreate: setOriginalFilter,
      onLocalFilterUpdate: setUpdatedFilter
    })), showConfirmModal && /*#__PURE__*/_react.default.createElement(_close_confirm_modal.CloseFilterEditorConfirmModal, {
      onCancel: onCancelModal,
      onConfirm: onConfirmModal
    }));
  };
}