"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.isOperator = exports.isOneOfOperator = exports.isNotOperator = exports.isNotOneOfOperator = exports.isNotBetweenOperator = exports.isBetweenOperator = exports.existsOperator = exports.doesNotExistOperator = exports.FILTER_OPERATORS = void 0;
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _fieldTypes = require("@kbn/field-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getIsOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isOperatorOptionLabel', {
    defaultMessage: 'is'
  }),
  getIsNotOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isNotOperatorOptionLabel', {
    defaultMessage: 'is not'
  }),
  getIsOneOfOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isOneOfOperatorOptionLabel', {
    defaultMessage: 'is one of'
  }),
  getIsNotOneOfOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isNotOneOfOperatorOptionLabel', {
    defaultMessage: 'is not one of'
  }),
  getIsBetweenOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isBetweenOperatorOptionLabel', {
    defaultMessage: 'is between'
  }),
  getIsNotBetweenOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isNotBetweenOperatorOptionLabel', {
    defaultMessage: 'is not between'
  }),
  getExistsOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.existsOperatorOptionLabel', {
    defaultMessage: 'exists'
  }),
  getDoesNotExistOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.doesNotExistOperatorOptionLabel', {
    defaultMessage: 'does not exist'
  })
};
exports.strings = strings;
const isOperator = {
  message: strings.getIsOperatorOptionLabel(),
  type: _esQuery.FILTERS.PHRASE,
  negate: false
};
exports.isOperator = isOperator;
const isNotOperator = {
  message: strings.getIsNotOperatorOptionLabel(),
  type: _esQuery.FILTERS.PHRASE,
  negate: true
};
exports.isNotOperator = isNotOperator;
const isOneOfOperator = {
  message: strings.getIsOneOfOperatorOptionLabel(),
  type: _esQuery.FILTERS.PHRASES,
  negate: false,
  fieldTypes: ['string', 'number', 'date', 'ip', 'geo_point', 'geo_shape']
};
exports.isOneOfOperator = isOneOfOperator;
const isNotOneOfOperator = {
  message: strings.getIsNotOneOfOperatorOptionLabel(),
  type: _esQuery.FILTERS.PHRASES,
  negate: true,
  fieldTypes: ['string', 'number', 'date', 'ip', 'geo_point', 'geo_shape']
};
exports.isNotOneOfOperator = isNotOneOfOperator;
const isBetweenOperator = {
  message: strings.getIsBetweenOperatorOptionLabel(),
  type: _esQuery.FILTERS.RANGE,
  negate: false,
  field: field => {
    var _field$esTypes;
    if (['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range'].includes(field.type)) return true;
    if (field.type === 'string' && (_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 && _field$esTypes.includes(_fieldTypes.ES_FIELD_TYPES.VERSION)) return true;
    return false;
  }
};
exports.isBetweenOperator = isBetweenOperator;
const isNotBetweenOperator = {
  message: strings.getIsNotBetweenOperatorOptionLabel(),
  type: _esQuery.FILTERS.RANGE,
  negate: true,
  field: field => {
    var _field$esTypes2;
    if (['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range'].includes(field.type)) return true;
    if (field.type === 'string' && (_field$esTypes2 = field.esTypes) !== null && _field$esTypes2 !== void 0 && _field$esTypes2.includes(_fieldTypes.ES_FIELD_TYPES.VERSION)) return true;
    return false;
  }
};
exports.isNotBetweenOperator = isNotBetweenOperator;
const existsOperator = {
  message: strings.getExistsOperatorOptionLabel(),
  type: _esQuery.FILTERS.EXISTS,
  negate: false
};
exports.existsOperator = existsOperator;
const doesNotExistOperator = {
  message: strings.getDoesNotExistOperatorOptionLabel(),
  type: _esQuery.FILTERS.EXISTS,
  negate: true
};
exports.doesNotExistOperator = doesNotExistOperator;
const FILTER_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, isBetweenOperator, isNotBetweenOperator, existsOperator, doesNotExistOperator];
exports.FILTER_OPERATORS = FILTER_OPERATORS;