"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterBadgeGroup = FilterBadgeGroup;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _filter_badge_error_boundary = require("./filter_badge_error_boundary");
var _filter_badge_expression = require("./filter_badge_expression");
var _filter_badge = require("./filter_badge.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const BooleanRelationDelimiter = ({
  conditional
}) => {
  /**
   *  Spaces have been added to make the title readable.
   */
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    className: _filter_badge.conditionCss
  }, ` ${conditional} `);
};
function FilterBadgeGroup({
  filters,
  dataViews,
  filterLabelStatus,
  booleanRelation,
  shouldShowBrackets = true
}) {
  return /*#__PURE__*/_react.default.createElement(_filter_badge_error_boundary.FilterBadgeErrorBoundary, null, filters.map((filter, index, filterArr) => {
    const showRelationDelimiter = booleanRelation && index + 1 < filterArr.length;
    const showBrackets = shouldShowBrackets && (filter.meta.negate || filterArr.length > 1);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_filter_badge_expression.FilterExpressionBadge, {
      filter: filter,
      shouldShowBrackets: showBrackets,
      dataViews: dataViews,
      filterLabelStatus: filterLabelStatus
    }), showRelationDelimiter && /*#__PURE__*/_react.default.createElement(BooleanRelationDelimiter, {
      conditional: booleanRelation
    }));
  }));
}

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = FilterBadgeGroup;
exports.default = _default;