"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedHistogramLayout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _css = require("@emotion/css");
var _resizableLayout = require("@kbn/resizable-layout");
var _chart = require("../chart");
var _use_lens_suggestions = require("./hooks/use_lens_suggestions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const UnifiedHistogramLayout = ({
  className,
  services,
  dataView,
  query,
  filters,
  currentSuggestion: originalSuggestion,
  isChartLoading,
  isPlainRecord,
  timeRange,
  relativeTimeRange,
  columns,
  request,
  hits,
  lensAdapters,
  lensEmbeddableOutput$,
  chart: originalChart,
  breakdown,
  container,
  topPanelHeight,
  appendHitsCounter,
  disableAutoFetching,
  disableTriggers,
  disabledActions,
  lensSuggestionsApi,
  input$,
  onTopPanelHeightChange,
  onChartHiddenChange,
  onTimeIntervalChange,
  onBreakdownFieldChange,
  onSuggestionChange,
  onTotalHitsChange,
  onChartLoad,
  onFilter,
  onBrushEnd,
  children,
  withDefaultActions
}) => {
  const {
    allSuggestions,
    currentSuggestion,
    suggestionUnsupported,
    isOnHistogramMode,
    histogramQuery
  } = (0, _use_lens_suggestions.useLensSuggestions)({
    dataView,
    query,
    originalSuggestion,
    isPlainRecord,
    columns,
    timeRange,
    data: services.data,
    lensSuggestionsApi,
    onSuggestionChange
  });
  const chart = suggestionUnsupported ? undefined : originalChart;
  const [topPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const [mainPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const showFixedPanels = isMobile || !chart || chart.hidden;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const defaultTopPanelHeight = euiTheme.base * 12;
  const minMainPanelHeight = euiTheme.base * 10;
  const chartClassName = isMobile && chart && !chart.hidden ? (0, _css.css)`
          height: ${defaultTopPanelHeight}px;
        ` : 'eui-fullHeight';
  const panelsMode = chart || hits ? showFixedPanels ? _resizableLayout.ResizableLayoutMode.Static : _resizableLayout.ResizableLayoutMode.Resizable : _resizableLayout.ResizableLayoutMode.Single;
  const currentTopPanelHeight = topPanelHeight !== null && topPanelHeight !== void 0 ? topPanelHeight : defaultTopPanelHeight;
  const onResetChartHeight = (0, _react.useMemo)(() => {
    return currentTopPanelHeight !== defaultTopPanelHeight && panelsMode === _resizableLayout.ResizableLayoutMode.Resizable ? () => onTopPanelHeightChange === null || onTopPanelHeightChange === void 0 ? void 0 : onTopPanelHeightChange(undefined) : undefined;
  }, [currentTopPanelHeight, defaultTopPanelHeight, onTopPanelHeightChange, panelsMode]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: topPanelNode
  }, /*#__PURE__*/_react.default.createElement(_chart.Chart, {
    className: chartClassName,
    services: services,
    dataView: dataView,
    query: query,
    filters: filters,
    timeRange: timeRange,
    relativeTimeRange: relativeTimeRange,
    request: request,
    hits: hits,
    currentSuggestion: currentSuggestion,
    isChartLoading: isChartLoading,
    allSuggestions: allSuggestions,
    isPlainRecord: isPlainRecord,
    chart: chart,
    breakdown: breakdown,
    appendHitsCounter: appendHitsCounter,
    appendHistogram: /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }),
    disableAutoFetching: disableAutoFetching,
    disableTriggers: disableTriggers,
    disabledActions: disabledActions,
    input$: input$,
    onResetChartHeight: onResetChartHeight,
    onChartHiddenChange: onChartHiddenChange,
    onTimeIntervalChange: onTimeIntervalChange,
    onBreakdownFieldChange: onBreakdownFieldChange,
    onSuggestionChange: onSuggestionChange,
    onTotalHitsChange: onTotalHitsChange,
    onChartLoad: onChartLoad,
    onFilter: onFilter,
    onBrushEnd: onBrushEnd,
    lensAdapters: lensAdapters,
    lensEmbeddableOutput$: lensEmbeddableOutput$,
    isOnHistogramMode: isOnHistogramMode,
    histogramQuery: histogramQuery,
    withDefaultActions: withDefaultActions
  })), /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: mainPanelNode
  }, children), /*#__PURE__*/_react.default.createElement(_resizableLayout.ResizableLayout, {
    className: className,
    mode: panelsMode,
    direction: _resizableLayout.ResizableLayoutDirection.Vertical,
    container: container,
    fixedPanelSize: currentTopPanelHeight,
    minFixedPanelSize: defaultTopPanelHeight,
    minFlexPanelSize: minMainPanelHeight,
    fixedPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: topPanelNode
    }),
    flexPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: mainPanelNode
    }),
    "data-test-subj": "unifiedHistogram",
    onFixedPanelSizeChange: onTopPanelHeightChange
  }));
};
exports.UnifiedHistogramLayout = UnifiedHistogramLayout;