"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreakdownFieldSelector = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _field_supports_breakdown = require("./utils/field_supports_breakdown");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TRUNCATION_PROPS = {
  truncation: 'middle'
};
const SINGLE_SELECTION = {
  asPlainText: true
};
const BreakdownFieldSelector = ({
  dataView,
  breakdown,
  onBreakdownFieldChange
}) => {
  var _breakdown$field;
  const fieldOptions = dataView.fields.filter(_field_supports_breakdown.fieldSupportsBreakdown).map(field => ({
    label: field.displayName,
    value: field.name
  })).sort((a, b) => a.label.toLowerCase().localeCompare(b.label.toLowerCase()));
  const selectedFields = breakdown.field ? [{
    label: breakdown.field.displayName,
    value: breakdown.field.name
  }] : [];
  const onFieldChange = (0, _react2.useCallback)(newOptions => {
    const field = newOptions.length ? dataView.fields.find(currentField => currentField.name === newOptions[0].value) : undefined;
    onBreakdownFieldChange === null || onBreakdownFieldChange === void 0 ? void 0 : onBreakdownFieldChange(field);
  }, [dataView.fields, onBreakdownFieldChange]);
  const [fieldPopoverDisabled, setFieldPopoverDisabled] = (0, _react2.useState)(false);
  const disableFieldPopover = (0, _react2.useCallback)(() => setFieldPopoverDisabled(true), []);
  const enableFieldPopover = (0, _react2.useCallback)(() => setTimeout(() => setFieldPopoverDisabled(false)), []);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const breakdownCss = (0, _react.css)`
    width: 100%;
    max-width: ${euiTheme.base * 22}px;
  `;
  const panelMinWidth = (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(fieldOptions, ['label']);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: fieldPopoverDisabled ? undefined : (_breakdown$field = breakdown.field) === null || _breakdown$field === void 0 ? void 0 : _breakdown$field.displayName,
    anchorProps: {
      css: breakdownCss
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "unifiedHistogramBreakdownFieldSelector",
    prepend: _i18n.i18n.translate('unifiedHistogram.breakdownFieldSelectorLabel', {
      defaultMessage: 'Break down by'
    }),
    placeholder: _i18n.i18n.translate('unifiedHistogram.breakdownFieldSelectorPlaceholder', {
      defaultMessage: 'Select field'
    }),
    "aria-label": _i18n.i18n.translate('unifiedHistogram.breakdownFieldSelectorAriaLabel', {
      defaultMessage: 'Break down by'
    }),
    inputPopoverProps: {
      panelMinWidth,
      anchorPosition: 'downRight'
    },
    singleSelection: SINGLE_SELECTION,
    options: fieldOptions,
    selectedOptions: selectedFields,
    onChange: onFieldChange,
    truncationProps: TRUNCATION_PROPS,
    compressed: true,
    fullWidth: true,
    onFocus: disableFieldPopover,
    onBlur: enableFieldPopover
  }));
};
exports.BreakdownFieldSelector = BreakdownFieldSelector;