"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handlebars = void 0;
var _handlebars = _interopRequireDefault(require("@kbn/handlebars"));
var _rison = require("@kbn/rison");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _moment = _interopRequireDefault(require("moment"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const handlebars = _handlebars.default.create();
exports.handlebars = handlebars;
function createSerializationHelper(fnName, serializeFn) {
  return (...args) => {
    const {
      hash
    } = args.slice(-1)[0];
    const hasHash = Object.keys(hash).length > 0;
    const hasValues = args.length > 1;
    if (hasHash && hasValues) {
      throw new Error(`[${fnName}]: both value list and hash are not supported`);
    }
    if (hasHash) {
      if (Object.values(hash).some(v => typeof v === 'undefined')) throw new Error(`[${fnName}]: unknown variable`);
      return serializeFn(hash);
    } else {
      const values = args.slice(0, -1);
      if (values.some(value => typeof value === 'undefined')) throw new Error(`[${fnName}]: unknown variable`);
      if (values.length === 0) throw new Error(`[${fnName}]: unknown variable`);
      if (values.length === 1) return serializeFn(values[0]);
      return serializeFn(values);
    }
  };
}
handlebars.registerHelper('json', createSerializationHelper('json', JSON.stringify));
handlebars.registerHelper('rison', createSerializationHelper('rison', v => (0, _rison.encode)(v)));
handlebars.registerHelper('date', (...args) => {
  const values = args.slice(0, -1);
  const {
    hash
  } = args.slice(-1)[0];
  // eslint-disable-next-line prefer-const
  let [date, format] = values;
  if (typeof date === 'undefined') throw new Error(`[date]: unknown variable`);
  let momentDate;
  if (typeof date === 'string') {
    momentDate = _datemath.default.parse(date, {
      roundUp: hash.roundUp === true
    });
    if (!momentDate || !momentDate.isValid()) {
      const ts = Number(date);
      if (!Number.isNaN(ts)) {
        momentDate = (0, _moment.default)(ts);
      }
    }
  } else {
    momentDate = (0, _moment.default)(date);
  }
  if (!momentDate || !momentDate.isValid()) {
    // do not throw error here, because it could be that in preview `__testValue__` is not parsable,
    // but in runtime it is
    return date;
  }
  return format ? momentDate.format(format) : momentDate.toISOString();
});
handlebars.registerHelper('formatNumber', (rawValue, pattern) => {
  if (!pattern || typeof pattern !== 'string') throw new Error(`[formatNumber]: pattern string is required`);
  const value = Number(rawValue);
  if (rawValue == null || Number.isNaN(value)) return rawValue;
  return (0, _numeral.default)(value).format(pattern);
});
handlebars.registerHelper('lowercase', rawValue => String(rawValue).toLowerCase());
handlebars.registerHelper('uppercase', rawValue => String(rawValue).toUpperCase());
handlebars.registerHelper('trim', rawValue => String(rawValue).trim());
handlebars.registerHelper('trimLeft', rawValue => String(rawValue).trimLeft());
handlebars.registerHelper('trimRight', rawValue => String(rawValue).trimRight());
handlebars.registerHelper('left', (rawValue, numberOfChars) => {
  if (typeof numberOfChars !== 'number') throw new Error('[left]: expected "number of characters to extract" to be a number');
  return String(rawValue).slice(0, numberOfChars);
});
handlebars.registerHelper('right', (rawValue, numberOfChars) => {
  if (typeof numberOfChars !== 'number') throw new Error('[left]: expected "number of characters to extract" to be a number');
  return String(rawValue).slice(-numberOfChars);
});
handlebars.registerHelper('mid', (rawValue, start, length) => {
  if (typeof start !== 'number') throw new Error('[left]: expected "start" to be a number');
  if (typeof length !== 'number') throw new Error('[left]: expected "length" to be a number');
  return String(rawValue).substr(start, length);
});
handlebars.registerHelper('concat', (...args) => {
  const values = args.slice(0, -1);
  return values.join('');
});
handlebars.registerHelper('split', (...args) => {
  const [str, splitter] = args.slice(0, -1);
  if (typeof splitter !== 'string') throw new Error('[split] "splitter" expected to be a string');
  return String(str).split(splitter);
});
handlebars.registerHelper('replace', (...args) => {
  const [str, searchString, valueString] = args.slice(0, -1);
  if (typeof searchString !== 'string' || typeof valueString !== 'string') throw new Error('[replace]: "searchString" and "valueString" parameters expected to be strings, but not a string or missing');
  return String(str).split(searchString).join(valueString);
});
handlebars.registerHelper('encodeURIComponent', component => {
  const str = String(component);
  return encodeURIComponent(str);
});
handlebars.registerHelper('encodeURIQuery', component => {
  const str = String(component);
  return _public.url.encodeUriQuery(str);
});