"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlDrilldownOptionsComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const UrlDrilldownOptionsComponent = ({
  options,
  onOptionChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "openInNewTab",
    name: "openInNewTab",
    label: _i18n.txtUrlTemplateOpenInNewTab,
    checked: options.openInNewTab,
    onChange: () => onOptionChange({
      openInNewTab: !options.openInNewTab
    }),
    "data-test-subj": "urlDrilldownOpenInNewTab"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "encodeUrl",
    name: "encodeUrl",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.txtUrlTemplateEncodeUrl, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 's'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, _i18n.txtUrlTemplateEncodeDescription)),
    checked: options.encodeUrl,
    onChange: () => onOptionChange({
      encodeUrl: !options.encodeUrl
    }),
    "data-test-subj": "urlDrilldownEncodeUrl"
  })));
};
exports.UrlDrilldownOptionsComponent = UrlDrilldownOptionsComponent;