"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ValueExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ValueExpression = ({
  description,
  value,
  onChangeSelectedValue,
  display = 'inline',
  popupPosition,
  errors
}) => {
  const [valuePopoverOpen, setValuePopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "valueExpression",
      description: description,
      value: value,
      isActive: valuePopoverOpen,
      display: display === 'inline' ? 'inline' : 'columns',
      onClick: () => {
        setValuePopoverOpen(true);
      },
      isInvalid: errors.length > 0
    }),
    isOpen: valuePopoverOpen,
    closePopover: () => {
      setValuePopoverOpen(false);
    },
    ownFocus: true,
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft',
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    "data-test-subj": "valueFieldTitle",
    onClose: () => setValuePopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "valueFieldNumberForm",
    isInvalid: errors.length > 0 && value !== undefined,
    error: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "valueFieldNumber",
    min: 0,
    value: value,
    isInvalid: errors.length > 0 && value !== undefined,
    onChange: e => {
      onChangeSelectedValue(e.target.value);
    }
  }))))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ValueExpression = ValueExpression;