"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.builtInComparators = exports.COMPARATORS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let COMPARATORS;
exports.COMPARATORS = COMPARATORS;
(function (COMPARATORS) {
  COMPARATORS["GREATER_THAN"] = ">";
  COMPARATORS["GREATER_THAN_OR_EQUALS"] = ">=";
  COMPARATORS["BETWEEN"] = "between";
  COMPARATORS["LESS_THAN"] = "<";
  COMPARATORS["LESS_THAN_OR_EQUALS"] = "<=";
  COMPARATORS["NOT_BETWEEN"] = "notBetween";
})(COMPARATORS || (exports.COMPARATORS = COMPARATORS = {}));
const builtInComparators = {
  [COMPARATORS.GREATER_THAN]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isAboveLabel', {
      defaultMessage: 'Is above'
    }),
    value: COMPARATORS.GREATER_THAN,
    requiredValues: 1
  },
  [COMPARATORS.GREATER_THAN_OR_EQUALS]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isAboveOrEqualsLabel', {
      defaultMessage: 'Is above or equals'
    }),
    value: COMPARATORS.GREATER_THAN_OR_EQUALS,
    requiredValues: 1
  },
  [COMPARATORS.LESS_THAN]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isBelowLabel', {
      defaultMessage: 'Is below'
    }),
    value: COMPARATORS.LESS_THAN,
    requiredValues: 1
  },
  [COMPARATORS.LESS_THAN_OR_EQUALS]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isBelowOrEqualsLabel', {
      defaultMessage: 'Is below or equals'
    }),
    value: COMPARATORS.LESS_THAN_OR_EQUALS,
    requiredValues: 1
  },
  [COMPARATORS.BETWEEN]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isBetweenLabel', {
      defaultMessage: 'Is between'
    }),
    value: COMPARATORS.BETWEEN,
    requiredValues: 2
  },
  [COMPARATORS.NOT_BETWEEN]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isNotBetweenLabel', {
      defaultMessage: 'Not between'
    }),
    value: COMPARATORS.NOT_BETWEEN,
    requiredValues: 2
  }
};
exports.builtInComparators = builtInComparators;