"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJsDomPerformanceFix = exports.createAppMockRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@testing-library/react");
var _kibana_react = require("../../common/lib/kibana/kibana_react.mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable no-console */

const createAppMockRenderer = queryClientContext => {
  const services = (0, _kibana_react.createStartServicesMock)();
  const theme$ = (0, _rxjs.of)({
    darkMode: false
  });
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    },
    /**
     * React query prints the errors in the console even though
     * all tests are passings. We turn them off for testing.
     */
    logger: {
      log: console.log,
      warn: console.warn,
      error: () => {}
    }
  });
  const AppWrapper = /*#__PURE__*/_react.default.memo(({
    children
  }) => /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    context: queryClientContext
  }, children)))));
  AppWrapper.displayName = 'AppWrapper';
  const render = (ui, options) => {
    return (0, _react2.render)(ui, {
      wrapper: AppWrapper,
      ...options
    });
  };
  return {
    coreStart: services,
    render,
    queryClient,
    AppWrapper
  };
};
exports.createAppMockRenderer = createAppMockRenderer;
const getJsDomPerformanceFix = () => {
  const originalGetComputedStyle = Object.assign({}, window.getComputedStyle);
  return {
    fix: () => {
      // The JSDOM implementation is too slow
      // Especially for dropdowns that try to position themselves
      // perf issue - https://github.com/jsdom/jsdom/issues/3234
      Object.defineProperty(window, 'getComputedStyle', {
        value: el => {
          /**
           * This is based on the jsdom implementation of getComputedStyle
           * https://github.com/jsdom/jsdom/blob/9dae17bf0ad09042cfccd82e6a9d06d3a615d9f4/lib/jsdom/browser/Window.js#L779-L820
           *
           * It is missing global style parsing and will only return styles applied directly to an element.
           * Will not return styles that are global or from emotion
           */
          const declaration = new CSSStyleDeclaration();
          const {
            style
          } = el;
          Array.prototype.forEach.call(style, property => {
            declaration.setProperty(property, style.getPropertyValue(property), style.getPropertyPriority(property));
          });
          return declaration;
        },
        configurable: true,
        writable: true
      });
    },
    cleanup: () => {
      Object.defineProperty(window, 'getComputedStyle', originalGetComputedStyle);
    }
  };
};
exports.getJsDomPerformanceFix = getJsDomPerformanceFix;