"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TypeFilter = ({
  options,
  onChange: onFilterChange,
  filters
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      hasActiveFilters: filters.length > 0,
      numActiveFilters: filters.length,
      numFilters: filters.length,
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      "data-test-subj": "ruleTypeFilterButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.typeFilterLabel",
      defaultMessage: "Type"
    }))
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    }
  }, options.map((groupItem, groupIndex) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: `group${groupIndex}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": `ruleType${groupIndex}Group`,
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, groupItem.groupName)), groupItem.subOptions.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    key: index,
    onClick: () => {
      const isPreviouslyChecked = filters.includes(item.value);
      if (isPreviouslyChecked) {
        onFilterChange(filters.filter(val => val !== item.value));
      } else {
        onFilterChange(filters.concat(item.value));
      }
    },
    checked: filters.includes(item.value) ? 'on' : undefined,
    "data-test-subj": `ruleType${item.value}FilterOption`
  }, item.name))))));
};
exports.TypeFilter = TypeFilter;