"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SnoozePanel = void 0;
Object.defineProperty(exports, "futureTimeToInterval", {
  enumerable: true,
  get: function () {
    return _helpers.futureTimeToInterval;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _scheduler = require("../scheduler");
var _base_snooze_panel = require("./base_snooze_panel");
var _helpers = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SnoozePanel = ({
  interval,
  snoozeRule,
  unsnoozeRule,
  showCancel,
  scheduledSnoozes,
  activeSnoozes,
  hasTitle = true,
  inPopover = false,
  showAddSchedule
}) => {
  const [isSchedulerOpen, setIsSchedulerOpen] = (0, _react.useState)(false);
  const [initialSchedule, setInitialSchedule] = (0, _react.useState)(null);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onSnoozeRule = (0, _react.useCallback)(async schedule => {
    setIsLoading(true);
    try {
      await snoozeRule(schedule);
    } finally {
      if (!inPopover) {
        setIsLoading(false);
      }
    }
  }, [inPopover, setIsLoading, snoozeRule]);
  const onUnsnoozeRule = (0, _react.useCallback)(async scheduleIds => {
    setIsLoading(true);
    try {
      await unsnoozeRule(scheduleIds);
    } finally {
      if (!inPopover) {
        setIsLoading(false);
      }
    }
  }, [inPopover, setIsLoading, unsnoozeRule]);
  const saveSnoozeSchedule = (0, _react.useCallback)(async schedule => {
    setIsLoading(true);
    try {
      await snoozeRule(schedule);
    } finally {
      if (!inPopover) {
        setIsLoading(false);
      }
    }
  }, [inPopover, snoozeRule, setIsLoading]);
  const cancelSnoozeSchedules = (0, _react.useCallback)(async scheduleIds => {
    setIsLoading(true);
    try {
      await unsnoozeRule(scheduleIds);
    } finally {
      if (!inPopover) {
        setIsLoading(false);
      }
    }
  }, [inPopover, unsnoozeRule, setIsLoading]);
  const onOpenScheduler = (0, _react.useCallback)(schedule => {
    setInitialSchedule(schedule !== null && schedule !== void 0 ? schedule : null);
    setIsSchedulerOpen(true);
  }, [setInitialSchedule, setIsSchedulerOpen]);
  const onCloseScheduler = (0, _react.useCallback)(() => setIsSchedulerOpen(false), [setIsSchedulerOpen]);
  return !isSchedulerOpen ? /*#__PURE__*/_react.default.createElement(_base_snooze_panel.BaseSnoozePanel, {
    isLoading: isLoading,
    snoozeRule: onSnoozeRule,
    unsnoozeRule: onUnsnoozeRule,
    interval: interval,
    showCancel: showCancel,
    showAddSchedule: showAddSchedule,
    scheduledSnoozes: scheduledSnoozes,
    activeSnoozes: activeSnoozes,
    navigateToScheduler: onOpenScheduler,
    onRemoveAllSchedules: cancelSnoozeSchedules,
    hasTitle: hasTitle,
    inPopover: inPopover
  }) : /*#__PURE__*/_react.default.createElement(_scheduler.RuleSnoozeScheduler, {
    isLoading: isLoading,
    initialSchedule: initialSchedule,
    onClose: onCloseScheduler,
    onSaveSchedule: saveSnoozeSchedule,
    onCancelSchedules: cancelSnoozeSchedules,
    hasTitle: hasTitle,
    inPopover: inPopover
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.SnoozePanel = SnoozePanel;