"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleStatusPanel = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ = require("../..");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _notify_badge = require("../../rules_list/components/notify_badge");
var _use_load_rule_event_logs = require("../../../hooks/use_load_rule_event_logs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleStatusPanel = ({
  rule,
  bulkEnableRules,
  bulkDisableRules,
  snoozeRule,
  unsnoozeRule,
  requestRefresh,
  isEditable,
  healthColor,
  statusMessage,
  refreshToken
}) => {
  const [lastNumberOfExecutions, setLastNumberOfExecutions] = (0, _react.useState)(null);
  const isInitialized = (0, _react.useRef)(false);
  const onSnoozeRule = (0, _react.useCallback)(snoozeSchedule => snoozeRule(rule, snoozeSchedule), [rule, snoozeRule]);
  const onUnsnoozeRule = (0, _react.useCallback)(scheduleIds => unsnoozeRule(rule, scheduleIds), [rule, unsnoozeRule]);
  const statusMessageDisplay = (0, _react.useMemo)(() => {
    if (!statusMessage) {
      var _rule$lastRun;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
        titleSize: "xs",
        title: "--",
        description: "",
        isLoading: !((_rule$lastRun = rule.lastRun) !== null && _rule$lastRun !== void 0 && _rule$lastRun.outcome) && !rule.nextRun
      });
    }
    return statusMessage;
  }, [rule, statusMessage]);
  const {
    data,
    loadEventLogs
  } = (0, _use_load_rule_event_logs.useLoadRuleEventLogs)({
    id: rule.id,
    dateStart: 'now-24h',
    dateEnd: 'now',
    page: 0,
    perPage: 10
  });
  (0, _react.useEffect)(() => {
    if (!data) {
      return;
    }
    setLastNumberOfExecutions(data.total);
  }, [data]);
  const requestRefreshInternal = (0, _react.useCallback)(() => {
    loadEventLogs();
    requestRefresh();
  }, [requestRefresh, loadEventLogs]);
  (0, _react.useEffect)(() => {
    if (isInitialized.current) {
      loadEventLogs();
    }
    isInitialized.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refreshToken]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "ruleStatusPanel",
    hasBorder: true,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.rule.statusPanel.ruleIsEnabledDisabledTitle",
    defaultMessage: "Rule is"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.RuleStatusDropdown, {
    disableRule: () => bulkDisableRules({
      ids: [rule.id]
    }),
    enableRule: () => bulkEnableRules({
      ids: [rule.id]
    }),
    snoozeRule: async () => {},
    unsnoozeRule: async () => {},
    rule: rule,
    onRuleChanged: requestRefreshInternal,
    direction: "row",
    isEditable: isEditable,
    hideSnoozeOption: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": "ruleStatus-numberOfExecutions"
  }, lastNumberOfExecutions !== null && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.rule.statusPanel.totalExecutions",
    defaultMessage: "{executions, plural, one {# execution} other {# executions}} in the last 24 hr",
    values: {
      executions: lastNumberOfExecutions
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": `ruleStatus-${rule.executionStatus.status}`,
    titleSize: "m",
    descriptionElement: "strong",
    titleElement: "h5",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": `ruleStatus-${rule.executionStatus.status}`,
      textSize: "m",
      color: healthColor,
      style: {
        fontWeight: 400
      }
    }, statusMessageDisplay),
    description: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.rulesList.ruleLastExecutionDescription', {
      defaultMessage: `Last response`
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, (0, _moment.default)(rule.executionStatus.lastExecutionDate).fromNow())))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_notify_badge.RulesListNotifyBadge, {
    snoozeSettings: rule,
    loading: !rule,
    disabled: !isEditable,
    onRuleChanged: requestRefreshInternal,
    snoozeRule: onSnoozeRule,
    unsnoozeRule: onUnsnoozeRule,
    showTooltipInline: true
  })));
};
exports.RuleStatusPanel = RuleStatusPanel;
const RuleStatusPanelWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleStatusPanel);

// eslint-disable-next-line import/no-default-export
exports.default = RuleStatusPanelWithApi;